/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.distribution.DistSyncFuncTest;
import org.infinispan.test.ReplListener;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistAsyncFuncTest")
public class DistAsyncFuncTest
extends DistSyncFuncTest {
    ReplListener r1;
    ReplListener r2;
    ReplListener r3;
    ReplListener r4;
    ReplListener[] r;
    Map<Cache<?, ?>, ReplListener> listenerLookup;

    public DistAsyncFuncTest() {
        this.sync = false;
        this.tx = false;
        this.testRetVals = true;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.r1 = new ReplListener(this.c1, true, true);
        this.r2 = new ReplListener(this.c2, true, true);
        this.r3 = new ReplListener(this.c3, true, true);
        this.r4 = new ReplListener(this.c4, true, true);
        this.r = new ReplListener[]{this.r1, this.r2, this.r3, this.r4};
        this.listenerLookup = new HashMap();
        for (ReplListener rl : this.r) {
            this.listenerLookup.put(rl.getCache(), rl);
        }
    }

    @Override
    protected void asyncWait(Object key, Class<? extends VisitableCommand> command, Cache<?, ?> ... cachesOnWhichKeyShouldInval) {
        if (key == null) {
            for (ReplListener replListener : this.r) {
                replListener.expect(command);
            }
            for (ReplListener replListener : this.r) {
                replListener.waitForRpc();
            }
        } else {
            for (Cache<Object, String> cache : this.getOwners(key)) {
                this.listenerLookup.get(cache).expect(command);
                this.listenerLookup.get(cache).waitForRpc();
            }
            if (cachesOnWhichKeyShouldInval != null) {
                for (Cache<?, ?> cache : cachesOnWhichKeyShouldInval) {
                    this.listenerLookup.get(cache).expect(InvalidateL1Command.class);
                    this.listenerLookup.get(cache).waitForRpc();
                }
            }
        }
        TestingUtil.sleepThread(1000L);
    }
}

