/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.infinispan.commands.control.CacheViewControlCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.InboundInvocationHandlerImpl;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.OngoingTransactionsAndJoinTest", enabled=false)
@CleanupAfterMethod
public class OngoingTransactionsAndJoinTest
extends MultipleCacheManagersTest {
    Configuration configuration;
    ScheduledExecutorService delayedExecutor = Executors.newScheduledThreadPool(1);

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configuration = OngoingTransactionsAndJoinTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC);
        this.configuration.setLockAcquisitionTimeout(60000L);
        this.configuration.setUseLockStriping(false);
        this.addClusterEnabledCacheManager(this.configuration);
    }

    private void injectListeningHandler(CacheContainer ecm, ListeningHandler lh) {
        TestingUtil.replaceComponent(ecm, InboundInvocationHandler.class, lh, true);
        JGroupsTransport t = (JGroupsTransport)TestingUtil.extractComponent(this.cache(0), Transport.class);
        CommandAwareRpcDispatcher card = t.getCommandAwareRpcDispatcher();
        Field f = null;
        try {
            f = card.getClass().getDeclaredField("inboundInvocationHandler");
            f.setAccessible(true);
            f.set(card, (Object)lh);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void testRehashOnJoin() throws InterruptedException {
        Object value;
        Cache firstNode = this.cache(0);
        CountDownLatch txsStarted = new CountDownLatch(3);
        CountDownLatch txsReady = new CountDownLatch(3);
        CountDownLatch joinEnded = new CountDownLatch(1);
        final CountDownLatch rehashStarted = new CountDownLatch(1);
        ListeningHandler listeningHandler = new ListeningHandler(TestingUtil.extractComponent(firstNode, InboundInvocationHandler.class), txsReady, joinEnded, rehashStarted);
        this.injectListeningHandler((CacheContainer)firstNode.getCacheManager(), listeningHandler);
        assert (firstNode.getAdvancedCache().getComponentRegistry().getComponent(InboundInvocationHandler.class) instanceof ListeningHandler);
        for (int i = 0; i < 10; ++i) {
            firstNode.put((Object)("OLD" + i), (Object)"value");
        }
        UnpreparedDuringRehashTask ut = new UnpreparedDuringRehashTask(firstNode, txsStarted, txsReady, joinEnded, rehashStarted);
        PrepareDuringRehashTask pt = new PrepareDuringRehashTask(firstNode, txsStarted, txsReady, joinEnded, rehashStarted);
        CommitDuringRehashTask ct = new CommitDuringRehashTask(firstNode, txsStarted, txsReady, joinEnded, rehashStarted);
        InterceptorChain ic = TestingUtil.extractComponent(firstNode, InterceptorChain.class);
        ic.addInterceptorAfter((CommandInterceptor)pt, TxInterceptor.class);
        ic.addInterceptorAfter((CommandInterceptor)ct, TxInterceptor.class);
        HashSet<Thread> threads = new HashSet<Thread>();
        threads.add(new Thread((Runnable)ut, "Worker-UnpreparedDuringRehashTask"));
        threads.add(new Thread((Runnable)pt, "Worker-PrepareDuringRehashTask"));
        threads.add(new Thread((Runnable)ct, "Worker-CommitDuringRehashTask"));
        for (Thread t : threads) {
            t.start();
        }
        txsStarted.await();
        this.delayedExecutor.schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                rehashStarted.countDown();
                return null;
            }
        }, 10L, TimeUnit.MILLISECONDS);
        this.addClusterEnabledCacheManager(this.configuration);
        ListeningHandler listeningHandler2 = new ListeningHandler(TestingUtil.extractComponent(firstNode, InboundInvocationHandler.class), txsReady, joinEnded, rehashStarted);
        this.injectListeningHandler((CacheContainer)this.cacheManagers.get(1), listeningHandler);
        Cache joiner = this.cache(1);
        for (Thread t : threads) {
            t.join();
        }
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1));
        for (int i = 0; i < 10; ++i) {
            Object key = "OLD" + i;
            value = joiner.get(key);
            this.log.infof(" TEST: Key %s is %s", key, value);
            assert ("value".equals(value)) : "Couldn't see key " + key + " on joiner!";
        }
        for (Object key : Arrays.asList(ut.key(), pt.key(), ct.key())) {
            value = joiner.get(key);
            this.log.infof(" TEST: Key %s is %s", key, value);
            assert ("value".equals(value)) : "Couldn't see key " + key + " on joiner!";
        }
    }

    class ListeningHandler
    extends InboundInvocationHandlerImpl {
        final InboundInvocationHandler delegate;
        final CountDownLatch txsReady;
        final CountDownLatch joinEnded;
        final CountDownLatch rehashStarted;

        public ListeningHandler(InboundInvocationHandler delegate, CountDownLatch txsReady, CountDownLatch joinEnded, CountDownLatch rehashStarted) {
            this.delegate = delegate;
            this.txsReady = txsReady;
            this.joinEnded = joinEnded;
            this.rehashStarted = rehashStarted;
        }

        public Response handle(CacheRpcCommand cmd, Address origin) throws Throwable {
            boolean notifyRehashStarted = false;
            if (cmd instanceof CacheViewControlCommand) {
                CacheViewControlCommand rcc = (CacheViewControlCommand)cmd;
                OngoingTransactionsAndJoinTest.this.log.debugf("Intercepted command: %s", (Object)cmd);
                switch (rcc.getType()) {
                    case PREPARE_VIEW: {
                        this.txsReady.await();
                        notifyRehashStarted = true;
                        break;
                    }
                    case COMMIT_VIEW: {
                        this.joinEnded.countDown();
                    }
                }
            }
            Response r = this.delegate.handle(cmd, origin);
            if (notifyRehashStarted) {
                this.rehashStarted.countDown();
            }
            return r;
        }
    }

    class CommitDuringRehashTask
    extends TransactionalTask {
        CommitDuringRehashTask(Cache<Object, Object> cache, CountDownLatch txsStarted, CountDownLatch txsReady, CountDownLatch joinEnded, CountDownLatch rehashStarted) {
            this.cache = cache;
            this.txsStarted = txsStarted;
            this.txsReady = txsReady;
            this.joinEnded = joinEnded;
            this.rehashStarted = rehashStarted;
        }

        @Override
        Object key() {
            return "commit_during_rehash";
        }

        @Override
        public void run() {
            try {
                this.startTx();
                OngoingTransactionsAndJoinTest.this.tm(this.cache).commit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object visitPrepareCommand(TxInvocationContext tcx, PrepareCommand cc) throws Throwable {
            Object o = super.visitPrepareCommand(tcx, cc);
            if (this.tx.equals(tcx.getTransaction())) {
                this.txsReady.countDown();
            }
            return o;
        }

        public Object visitCommitCommand(TxInvocationContext tcx, CommitCommand cc) throws Throwable {
            if (this.tx.equals(tcx.getTransaction())) {
                try {
                    this.rehashStarted.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return super.visitCommitCommand(tcx, cc);
        }
    }

    class PrepareDuringRehashTask
    extends TransactionalTask {
        PrepareDuringRehashTask(Cache<Object, Object> cache, CountDownLatch txsStarted, CountDownLatch txsReady, CountDownLatch joinEnded, CountDownLatch rehashStarted) {
            this.cache = cache;
            this.txsStarted = txsStarted;
            this.txsReady = txsReady;
            this.joinEnded = joinEnded;
            this.rehashStarted = rehashStarted;
        }

        @Override
        Object key() {
            return "prepare_during_rehash";
        }

        @Override
        public void run() {
            try {
                this.startTx();
                OngoingTransactionsAndJoinTest.this.tm(this.cache).commit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object visitPrepareCommand(TxInvocationContext tcx, PrepareCommand cc) throws Throwable {
            if (this.tx.equals(tcx.getTransaction())) {
                this.txsReady.countDown();
                this.rehashStarted.await();
            }
            return super.visitPrepareCommand(tcx, cc);
        }

        public Object visitCommitCommand(TxInvocationContext tcx, CommitCommand cc) throws Throwable {
            if (this.tx.equals(tcx.getTransaction())) {
                try {
                    this.joinEnded.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return super.visitCommitCommand(tcx, cc);
        }
    }

    class UnpreparedDuringRehashTask
    extends TransactionalTask {
        UnpreparedDuringRehashTask(Cache<Object, Object> cache, CountDownLatch txsStarted, CountDownLatch txsReady, CountDownLatch joinEnded, CountDownLatch rehashStarted) {
            this.cache = cache;
            this.txsStarted = txsStarted;
            this.txsReady = txsReady;
            this.joinEnded = joinEnded;
            this.rehashStarted = rehashStarted;
        }

        @Override
        Object key() {
            return "unprepared_during_rehash";
        }

        @Override
        public void run() {
            try {
                this.startTx();
                this.txsReady.countDown();
                this.joinEnded.await();
                OngoingTransactionsAndJoinTest.this.tm(this.cache).commit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    abstract class TransactionalTask
    extends CommandInterceptor
    implements Runnable {
        Cache<Object, Object> cache;
        CountDownLatch txsStarted;
        CountDownLatch txsReady;
        CountDownLatch joinEnded;
        CountDownLatch rehashStarted;
        volatile Transaction tx;

        TransactionalTask() {
        }

        protected void startTx() throws Exception {
            OngoingTransactionsAndJoinTest.this.tm(this.cache).begin();
            this.cache.put(this.key(), (Object)"value");
            this.tx = OngoingTransactionsAndJoinTest.this.tm(this.cache).getTransaction();
            this.tx.enlistResource((XAResource)new XAResourceAdapter());
            this.txsStarted.countDown();
        }

        abstract Object key();
    }
}

