/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.virtualnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.Util;
import org.jgroups.util.TopologyUUID;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="topologyaware.VNodesTachPerfTest", groups={"manual"})
public class VNodesTachPerfTest
extends AbstractInfinispanTest {
    private Set<Address> createAddresses(int numNodes) {
        HashSet<Address> addresses = new HashSet<Address>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            String machineId = "m" + i;
            addresses.add((Address)new JGroupsTopologyAwareAddress(TopologyUUID.randomUUID(null, null, (String)machineId)));
        }
        return addresses;
    }

    public void testSpeed() {
        int[] numNodes = new int[]{1, 2, 3, 4, 10, 100, 1000};
        int iterations = 100000;
        this.doPerfTest(10, 2, iterations);
        for (int numOwners = 1; numOwners < 5; ++numOwners) {
            System.out.println("numOwners=" + numOwners);
            for (int nn : numNodes) {
                Long duration = this.doPerfTest(nn, numOwners, iterations);
                System.out.println("With " + nn + " cache(s), time to do " + iterations + " lookups was " + Util.prettyPrintTime((long)TimeUnit.NANOSECONDS.toMillis(duration)));
            }
        }
    }

    private Long doPerfTest(int numNodes, int numOwners, int iterations) {
        ConsistentHash ch = this.createConsistentHash(numNodes);
        int dummy = 0;
        long start = System.nanoTime();
        for (int i = 0; i < iterations; ++i) {
            Integer key = i;
            dummy += ch.locate((Object)key, numOwners).size();
        }
        long duration = System.nanoTime() - start;
        Assert.assertEquals((int)dummy, (int)(iterations * Math.min(numOwners, numNodes)));
        return duration;
    }

    private ConsistentHash createConsistentHash(int numNodes) {
        Configuration c = new Configuration();
        c.fluent().hash().consistentHashClass(TopologyAwareConsistentHash.class).numVirtualNodes(Integer.valueOf(10));
        Set<Address> addresses = this.createAddresses(numNodes);
        return ConsistentHashHelper.createConsistentHash((Configuration)c, addresses);
    }

    public void testDistribution() {
        int numKeys = 10000;
        int[] numNodes = new int[]{1, 2, 3, 4, 10, 100};
        ArrayList<Object> keys = new ArrayList<Object>(10000);
        for (int i = 0; i < 10000; ++i) {
            keys.add(i);
        }
        for (int nn : numNodes) {
            this.doTestDistribution(10000, nn, keys);
        }
    }

    private void doTestDistribution(int numKeys, int numNodes, List<Object> keys) {
        ConsistentHash ch = this.createConsistentHash(numNodes);
        HashMap<Address, Integer> distribution = new HashMap<Address, Integer>();
        for (Object key : keys) {
            Address a = (Address)ch.locate(key, 1).get(0);
            if (distribution.containsKey(a)) {
                int i = (Integer)distribution.get(a);
                distribution.put(a, i + 1);
                continue;
            }
            distribution.put(a, 1);
        }
        System.out.printf("\nTesting distribution with %d keys, %d nodes\n", numKeys, numNodes);
        ArrayList counts = new ArrayList(distribution.values());
        Collections.sort(counts);
        Assert.assertEquals((int)numNodes, (int)counts.size());
        for (int i = 0; i < numNodes - counts.size(); ++i) {
            counts.add(0, 0);
        }
        double mean = 0.0;
        int sum = 0;
        for (Integer count : counts) {
            sum += count.intValue();
        }
        Assert.assertEquals((int)sum, (int)numKeys);
        mean = sum / numNodes;
        double variance = 0.0;
        for (Integer count : counts) {
            variance += ((double)count.intValue() - mean) * ((double)count.intValue() - mean);
        }
        double stdDev = Math.sqrt(variance);
        double avgAbsDev = 0.0;
        for (Integer count : counts) {
            avgAbsDev += Math.abs((double)count.intValue() - mean);
        }
        avgAbsDev /= (double)numNodes;
        int median = (Integer)counts.get(numNodes / 2);
        ArrayList<Integer> medianDevs = new ArrayList<Integer>(numNodes);
        for (Integer count : counts) {
            medianDevs.add(Math.abs(count - median));
        }
        Collections.sort(medianDevs);
        int medianAbsDev = (Integer)medianDevs.get(numNodes / 2);
        System.out.printf("Mean = %f, median = %d\n", mean, median);
        System.out.printf("Standard deviation = %.3f, or %.3f%%\n", stdDev, stdDev / mean * 100.0);
        System.out.printf("Average absolute deviation = %.3f, or %.3f%%\n", avgAbsDev, avgAbsDev / mean * 100.0);
        System.out.printf("Median absolute deviation = %d, or %.3f%%\n", medianAbsDev, (double)medianAbsDev / mean * 100.0);
    }
}

