/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="interceptors.MarshalledValueInterceptorTest")
public class MarshalledValueInterceptorTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager cm;

    @BeforeTest
    public void setUp() {
        this.cm = TestCacheManagerFactory.createLocalCacheManager(false);
    }

    @AfterTest
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
    }

    public void testDefaultInterceptorStack() {
        assert (TestingUtil.findInterceptor(this.cm.getCache(), MarshalledValueInterceptor.class) == null);
        Configuration configuration = new Configuration();
        configuration.setUseLazyDeserialization(true);
        this.cm.defineConfiguration("someCache", configuration);
        Cache c = this.cm.getCache("someCache");
        assert (TestingUtil.findInterceptor(c, MarshalledValueInterceptor.class) != null);
        TestingUtil.killCaches(c);
    }

    public void testDisabledInterceptorStack() {
        Configuration cfg = new Configuration();
        cfg.setUseLazyDeserialization(false);
        this.cm.defineConfiguration("a", cfg);
        Cache c = this.cm.getCache("a");
        assert (TestingUtil.findInterceptor(c, MarshalledValueInterceptor.class) == null);
    }

    public void testExcludedTypes() {
        assert (MarshalledValue.isTypeExcluded(String.class));
        assert (MarshalledValue.isTypeExcluded(String[].class));
        assert (MarshalledValue.isTypeExcluded(String[][].class));
        assert (MarshalledValue.isTypeExcluded(String[][][].class));
        assert (MarshalledValue.isTypeExcluded(Void.TYPE));
        assert (MarshalledValue.isTypeExcluded(Boolean.TYPE));
        assert (MarshalledValue.isTypeExcluded(Character.TYPE));
        assert (MarshalledValue.isTypeExcluded(Byte.TYPE));
        assert (MarshalledValue.isTypeExcluded(Short.TYPE));
        assert (MarshalledValue.isTypeExcluded(Integer.TYPE));
        assert (MarshalledValue.isTypeExcluded(Long.TYPE));
        assert (MarshalledValue.isTypeExcluded(Float.TYPE));
        assert (MarshalledValue.isTypeExcluded(Double.TYPE));
        assert (MarshalledValue.isTypeExcluded(boolean[].class));
        assert (MarshalledValue.isTypeExcluded(char[].class));
        assert (MarshalledValue.isTypeExcluded(byte[].class));
        assert (MarshalledValue.isTypeExcluded(short[].class));
        assert (MarshalledValue.isTypeExcluded(int[].class));
        assert (MarshalledValue.isTypeExcluded(long[].class));
        assert (MarshalledValue.isTypeExcluded(float[].class));
        assert (MarshalledValue.isTypeExcluded(double[].class));
        assert (MarshalledValue.isTypeExcluded(boolean[][].class));
        assert (MarshalledValue.isTypeExcluded(char[][].class));
        assert (MarshalledValue.isTypeExcluded(byte[][].class));
        assert (MarshalledValue.isTypeExcluded(short[][].class));
        assert (MarshalledValue.isTypeExcluded(int[][].class));
        assert (MarshalledValue.isTypeExcluded(long[][].class));
        assert (MarshalledValue.isTypeExcluded(float[][].class));
        assert (MarshalledValue.isTypeExcluded(double[][].class));
        assert (MarshalledValue.isTypeExcluded(Void.class));
        assert (MarshalledValue.isTypeExcluded(Boolean.class));
        assert (MarshalledValue.isTypeExcluded(Character.class));
        assert (MarshalledValue.isTypeExcluded(Byte.class));
        assert (MarshalledValue.isTypeExcluded(Short.class));
        assert (MarshalledValue.isTypeExcluded(Integer.class));
        assert (MarshalledValue.isTypeExcluded(Long.class));
        assert (MarshalledValue.isTypeExcluded(Float.class));
        assert (MarshalledValue.isTypeExcluded(Double.class));
        assert (MarshalledValue.isTypeExcluded(Boolean[].class));
        assert (MarshalledValue.isTypeExcluded(Character[].class));
        assert (MarshalledValue.isTypeExcluded(Byte[].class));
        assert (MarshalledValue.isTypeExcluded(Short[].class));
        assert (MarshalledValue.isTypeExcluded(Integer[].class));
        assert (MarshalledValue.isTypeExcluded(Long[].class));
        assert (MarshalledValue.isTypeExcluded(Float[].class));
        assert (MarshalledValue.isTypeExcluded(Double[].class));
        assert (MarshalledValue.isTypeExcluded(Boolean[][].class));
        assert (MarshalledValue.isTypeExcluded(Character[][].class));
        assert (MarshalledValue.isTypeExcluded(Byte[][].class));
        assert (MarshalledValue.isTypeExcluded(Short[][].class));
        assert (MarshalledValue.isTypeExcluded(Integer[][].class));
        assert (MarshalledValue.isTypeExcluded(Long[][].class));
        assert (MarshalledValue.isTypeExcluded(Float[][].class));
        assert (MarshalledValue.isTypeExcluded(Double[][].class));
    }

    public void testNonExcludedTypes() {
        assert (!MarshalledValue.isTypeExcluded(Object.class));
        assert (!MarshalledValue.isTypeExcluded(List.class));
        assert (!MarshalledValue.isTypeExcluded(Collection.class));
        assert (!MarshalledValue.isTypeExcluded(Map.class));
        assert (!MarshalledValue.isTypeExcluded(Date.class));
        assert (!MarshalledValue.isTypeExcluded(Thread.class));
        assert (!MarshalledValue.isTypeExcluded(Collection.class));
        assert (!MarshalledValue.isTypeExcluded(new Object(){
            String blah;
        }.getClass()));
    }
}

