/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ComponentsJmxRegistrationTest")
public class ComponentsJmxRegistrationTest
extends AbstractInfinispanTest {
    public static final String JMX_DOMAIN = ComponentsJmxRegistrationTest.class.getSimpleName();
    private MBeanServer mBeanServer;
    private List<EmbeddedCacheManager> cacheContainers = new ArrayList<EmbeddedCacheManager>();

    @BeforeMethod
    public void setUp() {
        this.mBeanServer = MBeanServerFactory.createMBeanServer();
        this.cacheContainers.clear();
    }

    @AfterMethod
    public void tearDown() {
        MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
        TestingUtil.killCacheManagers(this.cacheContainers);
        this.cacheContainers.clear();
    }

    public void testRegisterLocalCache() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        this.cacheContainers.add(cm);
        cm.start();
        Configuration configuration = this.config();
        configuration.setCacheMode(Configuration.CacheMode.LOCAL);
        cm.defineConfiguration("first", configuration);
        Cache first = cm.getCache("first");
        ComponentsJmxRegistration regComponents = this.buildRegistrator(first);
        regComponents.registerMBeans();
        String name = regComponents.getObjectName("Statistics").toString();
        ObjectName name1 = new ObjectName(name);
        assert (this.mBeanServer.isRegistered(name1));
        regComponents.unregisterMBeans();
        assert (!this.mBeanServer.isRegistered(name1));
        this.assertCorrectJmxName(name1, first);
    }

    private ComponentsJmxRegistration buildRegistrator(Cache cache) {
        AdvancedCache ac = (AdvancedCache)cache;
        Set components = ac.getComponentRegistry().getRegisteredComponents();
        String groupName = "name=" + ObjectName.quote(cache.getName());
        ComponentsJmxRegistration registrator = new ComponentsJmxRegistration(this.mBeanServer, components, groupName);
        registrator.setJmxDomain(JMX_DOMAIN);
        return registrator;
    }

    public void testRegisterReplicatedCache() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setAllowDuplicateDomains(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        this.cacheContainers.add(cm);
        cm.start();
        Configuration configurationOverride = this.config();
        configurationOverride.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        cm.defineConfiguration("first", configurationOverride);
        Cache first = cm.getCache("first");
        ComponentsJmxRegistration regComponents = this.buildRegistrator(first);
        regComponents.registerMBeans();
        String name = regComponents.getObjectName("Statistics").toString();
        ObjectName name1 = new ObjectName(name);
        this.assertCorrectJmxName(name1, first);
        assert (this.mBeanServer.isRegistered(name1));
        regComponents.unregisterMBeans();
        assert (!this.mBeanServer.isRegistered(name1));
    }

    public void testLocalAndReplicatedCache() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setAllowDuplicateDomains(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        this.cacheContainers.add(cm);
        cm.start();
        Configuration replicated = this.config();
        Configuration local = this.config();
        replicated.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        local.setCacheMode(Configuration.CacheMode.LOCAL);
        cm.defineConfiguration("replicated", replicated);
        cm.defineConfiguration("local", local);
        Cache replicatedCache = cm.getCache("replicated");
        Cache localCache = cm.getCache("local");
        ComponentsJmxRegistration replicatedRegComponents = this.buildRegistrator(replicatedCache);
        ComponentsJmxRegistration localRegComponents = this.buildRegistrator(localCache);
        replicatedRegComponents.registerMBeans();
        localRegComponents.registerMBeans();
        String replicatedtCMgmtIntName = replicatedRegComponents.getObjectName("Statistics").toString();
        String localCMgmtIntName = localRegComponents.getObjectName("Statistics").toString();
        ObjectName replObjectName = new ObjectName(replicatedtCMgmtIntName);
        ObjectName localObjName = new ObjectName(localCMgmtIntName);
        this.assertCorrectJmxName(replObjectName, replicatedCache);
        assert (this.mBeanServer.isRegistered(replObjectName));
        assert (this.mBeanServer.isRegistered(localObjName));
        assert (!localCMgmtIntName.equals(replicatedtCMgmtIntName));
        replicatedRegComponents.unregisterMBeans();
        localRegComponents.unregisterMBeans();
        assert (!this.mBeanServer.isRegistered(new ObjectName(localCMgmtIntName)));
        assert (!this.mBeanServer.isRegistered(new ObjectName(replicatedtCMgmtIntName)));
    }

    private void assertCorrectJmxName(ObjectName objectName, Cache cache) {
        assert (ObjectName.unquote(objectName.getKeyProperty(ComponentsJmxRegistration.NAME_KEY)).startsWith(cache.getName()));
        assert (objectName.getKeyProperty(ComponentsJmxRegistration.COMPONENT_KEY) != null);
    }

    private Configuration config() {
        Configuration configuration = new Configuration();
        configuration.setFetchInMemoryState(false);
        configuration.setExposeJmxStatistics(true);
        return configuration;
    }
}

