/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanServer;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CustomMBeanServerPropertiesTest")
public class CustomMBeanServerPropertiesTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeclarativeCustomMBeanServerLookupProperties() throws IOException {
        String cfg = "<infinispan><global><globalJmxStatistics enabled=\"true\" mBeanServerLookup=\"" + TestLookup.class.getName() + "\">" + "<properties>" + "<property name=\"key\" value=\"value\"/>" + "</properties>" + "</globalJmxStatistics>" + "</global>" + "<default><jmxStatistics enabled=\"true\"/></default>" + "</infinispan>";
        ByteArrayInputStream stream = new ByteArrayInputStream(cfg.getBytes());
        EmbeddedCacheManager cc = null;
        try {
            cc = TestCacheManagerFactory.fromStream(stream);
            cc.getCache();
            assert ("value".equals(TestLookup.p.get("key")));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{cc});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{cc});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProgrammaticCustomMBeanServerLookupProperties() {
        EmbeddedCacheManager cc = null;
        try {
            GlobalConfiguration gc = new GlobalConfiguration();
            TestLookup mbsl = new TestLookup();
            gc.setMBeanServerLookupInstance((MBeanServerLookup)mbsl);
            Properties p = new Properties();
            p.setProperty("key", "value");
            gc.setMBeanServerProperties(p);
            Configuration cfg = new Configuration();
            cfg.setExposeJmxStatistics(true);
            cc = TestCacheManagerFactory.createCacheManager(gc, cfg);
            cc.getCache();
            assert ("value".equals(mbsl.localProps.get("key")));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{cc});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{cc});
    }

    public static class TestLookup
    implements MBeanServerLookup {
        static Properties p;
        Properties localProps;

        public MBeanServer getMBeanServer(Properties properties) {
            p = properties;
            this.localProps = properties;
            return new PerThreadMBeanServerLookup().getMBeanServer(p);
        }
    }
}

