/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.annotations.Test;

@Test
public abstract class AbstractLockOwnerCrashTest
extends AbstractCrashTest {
    protected DummyTransaction transaction;

    public AbstractLockOwnerCrashTest(Configuration.CacheMode cacheMode, LockingMode lockingMode, Boolean useSynchronization) {
        super(cacheMode, lockingMode, useSynchronization);
    }

    public void testOwnerChangesAfterPrepare1() throws Exception {
        this.testOwnerChangesAfterPrepare(0);
    }

    public void testOwnerChangesAfterPrepare2() throws Exception {
        this.testOwnerChangesAfterPrepare(1);
    }

    private void testOwnerChangesAfterPrepare(final int secondTxNode) throws Exception {
        final Object k = this.getKeyForCache(2);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractLockOwnerCrashTest.this.tm(1).begin();
                    AbstractLockOwnerCrashTest.this.cache(1).put(k, (Object)"v");
                    AbstractLockOwnerCrashTest.this.transaction = (DummyTransaction)AbstractLockOwnerCrashTest.this.tm(1).getTransaction();
                    AbstractLockOwnerCrashTest.this.log.trace((Object)"Before preparing");
                    AbstractLockOwnerCrashTest.this.transaction.notifyBeforeCompletion();
                    AbstractLockOwnerCrashTest.this.transaction.runPrepare();
                    AbstractLockOwnerCrashTest.this.tm(1).suspend();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractLockOwnerCrashTest.this.checkTxCount(0, 0, 1) && AbstractLockOwnerCrashTest.this.checkTxCount(1, 1, 0) && AbstractLockOwnerCrashTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.killMember(2);
        this.cacheManagers.remove(2);
        assert (this.caches().size() == 2);
        this.tm(secondTxNode).begin();
        final Transaction suspend = this.tm(secondTxNode).suspend();
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractLockOwnerCrashTest.this.log.trace((Object)"This thread runs a different tx");
                    AbstractLockOwnerCrashTest.this.cache(secondTxNode).put(k, (Object)"v2");
                    AbstractLockOwnerCrashTest.this.tm(secondTxNode).resume(suspend);
                    AbstractLockOwnerCrashTest.this.tm(secondTxNode).commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, false);
        Thread.sleep(1000L);
        this.log.trace((Object)"Before completing the transaction!");
        this.tm(1).resume((Transaction)this.transaction);
        this.transaction.runCommitTx();
        this.transaction.notifyAfterCompletion(3);
        this.tm(1).suspend();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractLockOwnerCrashTest.this.cache(0).get(k).equals("v2") && AbstractLockOwnerCrashTest.this.cache(1).get(k).equals("v2");
            }
        }, 15000L);
        this.assertNotLocked(k);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractLockOwnerCrashTest.this.checkTxCount(0, 0, 0) && AbstractLockOwnerCrashTest.this.checkTxCount(1, 0, 0);
            }
        });
    }
}

