/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.optimistic;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractNoCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.BasicSingleLockOptimisticTest")
public class BasicSingleLockOptimisticTest
extends AbstractNoCrashTest {
    public BasicSingleLockOptimisticTest() {
        super(Configuration.CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, false);
    }

    @Override
    protected void testTxAndLockOnDifferentNodes(AbstractNoCrashTest.Operation operation, boolean addFirst, boolean removed) throws Exception {
        Object k = this.getKeyForCache(1);
        if (addFirst) {
            this.cache(0).put(k, (Object)"v_initial");
        }
        this.assertNotLocked(k);
        this.tm(0).begin();
        operation.perform(k, 0);
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        assert (!this.lockManager(0).isLocked(k));
        assert (this.lockManager(1).isLocked(k));
        assert (!this.lockManager(2).isLocked(k));
        dtm.runCommitTx();
        this.tm(0).suspend();
        this.assertNotLocked(k);
        this.assertValue(k, removed);
    }

    public void testMultipleLocksInSameTx() throws Exception {
        Object k1 = this.getKeyForCache(1);
        Object k2 = this.getKeyForCache(2);
        Assert.assertEquals(this.advancedCache(0).getDistributionManager().locate(k1).get(0), (Object)this.address(1));
        this.log.tracef("k1=%s, k2=%s", k1, k2);
        this.tm(0).begin();
        this.cache(0).put(k1, (Object)"v");
        this.cache(0).put(k2, (Object)"v");
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        assert (!this.lockManager(0).isLocked(k1));
        assert (this.lockManager(1).isLocked(k1));
        assert (!this.lockManager(2).isLocked(k1));
        assert (!this.lockManager(0).isLocked(k2));
        assert (!this.lockManager(1).isLocked(k2));
        assert (this.lockManager(2).isLocked(k2));
        dtm.runCommitTx();
        this.tm(0).suspend();
        this.assertNotLocked(k1);
        this.assertNotLocked(k2);
        this.assertValue(k1, false);
        this.assertValue(k2, false);
    }

    public void testSecondTxCannotPrepare() throws Exception {
        Object k = this.getKeyForCache(0);
        this.tm(0).begin();
        this.cache(0).put(k, (Object)"v");
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        this.tm(0).suspend();
        assert (this.checkTxCount(0, 1, 0));
        assert (this.checkTxCount(1, 0, 1));
        assert (this.checkTxCount(2, 0, 1));
        this.tm(0).begin();
        this.cache(0).put(k, (Object)"other");
        try {
            this.tm(0).commit();
            assert (false);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockOptimisticTest.this.checkTxCount(0, 1, 0) && BasicSingleLockOptimisticTest.this.checkTxCount(1, 0, 1) && BasicSingleLockOptimisticTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.log.info((Object)"Before second failure");
        this.tm(1).begin();
        this.cache(1).put(k, (Object)"other");
        try {
            this.tm(1).commit();
            assert (false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockOptimisticTest.this.checkTxCount(0, 1, 0) && BasicSingleLockOptimisticTest.this.checkTxCount(1, 0, 1) && BasicSingleLockOptimisticTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.tm(0).resume((Transaction)dtm);
        dtm.runCommitTx();
        dtm.notifyAfterCompletion(3);
        this.tm(0).suspend();
        this.assertValue(k, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockOptimisticTest.this.noPendingTransactions(0) && BasicSingleLockOptimisticTest.this.noPendingTransactions(1) && BasicSingleLockOptimisticTest.this.noPendingTransactions(2);
            }
        });
    }
}

