/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import java.util.List;
import java.util.concurrent.CyclicBarrier;
import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachemanagerlistener.CacheManagerNotifierTest")
public class CacheManagerNotifierTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm1, this.cm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMockViewChange() {
        this.cm1 = TestCacheManagerFactory.createClusteredCacheManager();
        this.cm2 = TestCacheManagerFactory.createClusteredCacheManager();
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setFetchInMemoryState(false);
        this.cm1.defineConfiguration("cache", c);
        this.cm2.defineConfiguration("cache", c);
        this.cm1.getCache("cache");
        assert (this.cm1.getMembers().size() == 1);
        Address myAddress = this.cm1.getAddress();
        assert (this.cm1.getMembers().contains(myAddress));
        CacheManagerNotifier mockNotifier = (CacheManagerNotifier)EasyMock.createMock(CacheManagerNotifier.class);
        CacheManagerNotifier origNotifier = TestingUtil.replaceComponent((CacheContainer)this.cm1, CacheManagerNotifier.class, mockNotifier, true);
        try {
            mockNotifier.notifyViewChange((List)EasyMock.isA(List.class), (List)EasyMock.isA(List.class), (Address)EasyMock.eq((Object)myAddress), EasyMock.anyInt());
            EasyMock.replay((Object[])new Object[]{mockNotifier});
            Cache c2 = this.cm2.getCache("cache");
            TestingUtil.blockUntilViewsReceived(60000L, new CacheContainer[]{this.cm1, this.cm2});
            EasyMock.verify((Object[])new Object[]{mockNotifier});
        }
        finally {
            TestingUtil.replaceComponent((CacheContainer)this.cm1, CacheManagerNotifier.class, origNotifier, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewChange() throws Exception {
        EmbeddedCacheManager cmA = TestCacheManagerFactory.createClusteredCacheManager();
        cmA.getCache();
        CyclicBarrier barrier = new CyclicBarrier(2);
        GetCacheManagerCheckListener listener = new GetCacheManagerCheckListener(barrier);
        cmA.addListener((Object)listener);
        EmbeddedCacheManager cmB = TestCacheManagerFactory.createClusteredCacheManager();
        cmB.getCache();
        try {
            barrier.await();
            barrier.await();
            assert (listener.cacheContainer != null);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{cmA, cmB});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{cmA, cmB});
    }

    @Listener
    public static class GetCacheManagerCheckListener {
        CacheContainer cacheContainer;
        CyclicBarrier barrier;

        public GetCacheManagerCheckListener(CyclicBarrier barrier) {
            this.barrier = barrier;
        }

        @ViewChanged
        public void onViewChange(ViewChangedEvent e) throws Exception {
            this.barrier.await();
            this.cacheContainer = e.getCacheManager();
            this.barrier.await();
        }
    }
}

