/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionTable;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class RemoteTxNotCreatedOnGetTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration dcc = RemoteTxNotCreatedOnGetTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        dcc.fluent().l1().disable().hash().numOwners(Integer.valueOf(1));
        this.createCluster(dcc, 2);
        this.waitForClusterToForm();
    }

    public void testRemoteTxCreation() throws Throwable {
        Object key = this.getKeyForCache(1);
        this.cache(1).put(key, (Object)"v");
        Assert.assertEquals((Object)"v", (Object)this.cache(0).get(key));
        Assert.assertEquals((Object)"v", (Object)this.cache(1).get(key));
        Thread.sleep(1000L);
        TransactionTable tt1 = TestingUtil.getTransactionTable(this.cache(1));
        Assert.assertEquals((int)tt1.getRemoteTransactions().size(), (int)0);
        this.tm(0).begin();
        this.log.trace((Object)"Before going remotely");
        this.cache(0).get(key);
        Assert.assertEquals((int)tt1.getRemoteTransactions().size(), (int)0);
        this.tm(0).commit();
    }
}

