/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.UUID;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyXid;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="tx.TransactionXaAdapterTmIntegrationTest", groups={"unit"}, enabled=false, description="Disabled due to instability - see ISPN-1123")
public class TransactionXaAdapterTmIntegrationTest {
    private Configuration configuration;
    private XaTransactionTable txTable;
    private GlobalTransaction globalTransaction;
    private LocalXaTransaction localTx;
    private TransactionXaAdapter xaAdapter;
    private DummyXid xid;
    private UUID uuid = UUID.randomUUID();

    @BeforeMethod
    public void setUp() {
        this.txTable = new XaTransactionTable();
        TransactionFactory gtf = new TransactionFactory();
        gtf.init(false, false, true);
        this.globalTransaction = gtf.newGlobalTransaction(null, false);
        this.localTx = new LocalXaTransaction((Transaction)new DummyTransaction(null), this.globalTransaction, false, 1);
        this.xid = new DummyXid(this.uuid);
        this.localTx.setXid((Xid)this.xid);
        this.txTable.addLocalTransactionMapping(this.localTx);
        this.configuration = new Configuration();
        TransactionCoordinator txCoordinator = new TransactionCoordinator();
        txCoordinator.init(null, null, null, null, this.configuration);
        this.xaAdapter = new TransactionXaAdapter(this.localTx, (TransactionTable)this.txTable, this.configuration, null, txCoordinator, null, null, (ClusteringDependentLogic)new ClusteringDependentLogic.AllNodesLogic(), this.configuration);
    }

    public void testPrepareOnNonexistentXid() {
        block3: {
            DummyXid xid = new DummyXid(this.uuid);
            try {
                this.xaAdapter.prepare((Xid)xid);
                assert (false);
            }
            catch (XAException e) {
                if ($assertionsDisabled || e.errorCode == -4) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testCommitOnNonexistentXid() {
        block3: {
            DummyXid xid = new DummyXid(this.uuid);
            try {
                this.xaAdapter.commit((Xid)xid, false);
                assert (false);
            }
            catch (XAException e) {
                if ($assertionsDisabled || e.errorCode == -4) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testRollabckOnNonexistentXid() {
        block3: {
            DummyXid xid = new DummyXid(this.uuid);
            try {
                this.xaAdapter.rollback((Xid)xid);
                assert (false);
            }
            catch (XAException e) {
                if ($assertionsDisabled || e.errorCode == -4) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testPrepareTxMarkedForRollback() {
        block3: {
            this.localTx.markForRollback(true);
            try {
                this.xaAdapter.prepare((Xid)this.xid);
                assert (false);
            }
            catch (XAException e) {
                if ($assertionsDisabled || e.errorCode == 100) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testOnePhaseCommitConfigured() throws XAException {
        this.configuration.setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        assert (0 == this.xaAdapter.prepare((Xid)this.xid));
    }

    public void test1PcAndNonExistentXid() {
        block3: {
            this.configuration.setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
            try {
                DummyXid doesNotExists = new DummyXid(this.uuid);
                this.xaAdapter.commit((Xid)doesNotExists, false);
                assert (false);
            }
            catch (XAException e) {
                if ($assertionsDisabled || e.errorCode == -4) break block3;
                throw new AssertionError();
            }
        }
    }

    public void test1PcAndNonExistentXid2() {
        block3: {
            this.configuration.setCacheMode(Configuration.CacheMode.DIST_SYNC);
            try {
                DummyXid doesNotExists = new DummyXid(this.uuid);
                this.xaAdapter.commit((Xid)doesNotExists, true);
                assert (false);
            }
            catch (XAException e) {
                if ($assertionsDisabled || e.errorCode == -4) break block3;
                throw new AssertionError();
            }
        }
    }
}

