/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.dev;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesLister {
    public void listByName(PrintStream out) {
        ArrayList<MAPIProperty> all = new ArrayList<MAPIProperty>(MAPIProperty.getAll());
        Collections.sort(all, new Comparator<MAPIProperty>(){

            @Override
            public int compare(MAPIProperty a, MAPIProperty b) {
                return a.name.compareTo(b.name);
            }
        });
        this.list(all, out);
    }

    public void listById(PrintStream out) {
        ArrayList<MAPIProperty> all = new ArrayList<MAPIProperty>(MAPIProperty.getAll());
        Collections.sort(all, new Comparator<MAPIProperty>(){

            @Override
            public int compare(MAPIProperty a, MAPIProperty b) {
                if (a.id < b.id) {
                    return -1;
                }
                if (a.id > b.id) {
                    return 1;
                }
                return 0;
            }
        });
        this.list(all, out);
    }

    private void list(ArrayList<MAPIProperty> list, PrintStream out) {
        for (MAPIProperty attr : list) {
            String id = Integer.toHexString(attr.id);
            while (id.length() < 4) {
                id = "0" + id;
            }
            out.println("0x" + id + " - " + attr.name);
            out.println("   " + attr.id + " - " + Types.asName(attr.usualType) + " (" + attr.usualType + ") - " + attr.mapiProperty);
        }
    }

    public static void main(String[] args) {
        TypesLister lister = new TypesLister();
        lister.listByName(System.out);
        System.out.println();
        lister.listById(System.out);
    }
}

