/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.util.impl.ScopedAnalyzer;

public class ConnectedQueryContextBuilder
implements QueryContextBuilder {
    private final SearchFactoryImplementor factory;

    public ConnectedQueryContextBuilder(SearchFactoryImplementor factory) {
        this.factory = factory;
    }

    @Override
    public EntityContext forEntity(Class<?> entityType) {
        return new HSearchEntityContext(entityType, this.factory);
    }

    public final class HSearchEntityContext
    implements EntityContext {
        private final ScopedAnalyzer queryAnalyzer = new ScopedAnalyzer();
        private final QueryBuildingContext context;

        public HSearchEntityContext(Class<?> entityType, SearchFactoryImplementor factory) {
            this.queryAnalyzer.setGlobalAnalyzer(factory.getAnalyzer(entityType));
            this.context = new QueryBuildingContext(factory, this.queryAnalyzer, entityType);
        }

        @Override
        public EntityContext overridesForField(String field, String analyzerName) {
            this.queryAnalyzer.addScopedAnalyzer(field, ConnectedQueryContextBuilder.this.factory.getAnalyzer(analyzerName));
            return this;
        }

        @Override
        public QueryBuilder get() {
            return new ConnectedQueryBuilder(this.context);
        }
    }
}

