/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc;

import java.lang.reflect.Method;
import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.ReplListener;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionTable;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.PutForExternalReadTest")
@CleanupAfterMethod
public class PutForExternalReadTest
extends MultipleCacheManagersTest {
    final String key = "k";
    final String value = "v";
    final String value2 = "v2";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = PutForExternalReadTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        this.createClusteredCaches(2, "replSync", c);
    }

    public void testNoOpWhenKeyPresent() {
        final Cache cache1 = this.cache(0, "replSync");
        final Cache cache2 = this.cache(1, "replSync");
        cache1.putForExternalRead((Object)"k", (Object)"v");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(cache1.get((Object)"k")) && "v".equals(cache2.get((Object)"k"));
            }
        });
        cache1.remove((Object)"k");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return cache1.isEmpty() && cache2.isEmpty();
            }
        });
        cache1.put((Object)"k", (Object)"v");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(cache1.get((Object)"k")) && "v".equals(cache2.get((Object)"k"));
            }
        });
        cache1.putForExternalRead((Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)"v", (String)((String)cache1.get((Object)"k")));
        AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)"v", (String)((String)cache2.get((Object)"k")));
    }

    private List<Address> anyAddresses() {
        Matchers.anyObject();
        return null;
    }

    private ResponseMode anyResponseMode() {
        Matchers.anyObject();
        return null;
    }

    public void testTxSuspension() throws Exception {
        final Cache cache1 = this.cache(0, "replSync");
        final Cache cache2 = this.cache(1, "replSync");
        cache1.put((Object)"k0", (Object)"v");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(cache2.get((Object)"k0"));
            }
        });
        this.tm(0, "replSync").begin();
        cache1.get((Object)"k0");
        cache1.putForExternalRead((Object)"k", (Object)"v");
        Transaction t = this.tm(0, "replSync").suspend();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(cache1.get((Object)"k")) && "v".equals(cache2.get((Object)"k"));
            }
        });
        this.tm(0, "replSync").resume(t);
        this.tm(0, "replSync").commit();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(cache1.get((Object)"k0")) && "v".equals(cache2.get((Object)"k0"));
            }
        });
    }

    public void testExceptionSuppression() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        Transport originalTransport = TestingUtil.extractComponent(cache1, Transport.class);
        Transport mockTransport = (Transport)Mockito.spy((Object)originalTransport);
        ((Transport)Mockito.doThrow((Throwable)new RuntimeException("Barf!")).when((Object)mockTransport)).invokeRemotely(this.anyAddresses(), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), this.anyResponseMode(), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject());
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        rpcManager.setTransport(mockTransport);
        try {
            cache1.put((Object)"k", (Object)"v");
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            cache1.remove((Object)"k");
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        AssertJUnit.assertNull((String)"Should have cleaned up", (Object)cache1.get((Object)"k"));
        AssertJUnit.assertNull((String)"Should have cleaned up", (Object)cache1.getAdvancedCache().getDataContainer().get((Object)"k"));
        AssertJUnit.assertNull((String)"Should have cleaned up", (Object)cache2.get((Object)"k"));
        AssertJUnit.assertNull((String)"Should have cleaned up", (Object)cache2.getAdvancedCache().getDataContainer().get((Object)"k"));
        cache1.putForExternalRead((Object)"k", (Object)"v");
    }

    public void testBasicPropagation() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        assert (!cache1.containsKey((Object)"k"));
        assert (!cache2.containsKey((Object)"k"));
        ReplListener replListener2 = this.replListener(cache2);
        replListener2.expect(PutKeyValueCommand.class);
        cache1.putForExternalRead((Object)"k", (Object)"v");
        replListener2.waitForRpc();
        AssertJUnit.assertEquals((String)"PFER updated cache1", (String)"v", (String)((String)cache1.get((Object)"k")));
        AssertJUnit.assertEquals((String)"PFER propagated to cache2 as expected", (String)"v", (String)((String)cache2.get((Object)"k")));
        cache2.putForExternalRead((Object)"k", (Object)"v0");
        AssertJUnit.assertEquals((String)"PFER updated cache2", (String)"v", (String)((String)cache2.get((Object)"k")));
        AssertJUnit.assertEquals((String)"Cache1 should be unaffected", (String)"v", (String)((String)cache1.get((Object)"k")));
    }

    public void testSimpleCacheModeLocal(Method m) throws Exception {
        this.cacheModeLocalTest(false, m);
    }

    public void testCacheModeLocalInTx(Method m) throws Exception {
        this.cacheModeLocalTest(true, m);
    }

    public void testMemLeakOnSuspendedTransactions() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        TransactionManager tm1 = TestingUtil.getTransactionManager(cache1);
        TransactionManager tm2 = TestingUtil.getTransactionManager(cache2);
        ReplListener replListener2 = this.replListener(cache2);
        replListener2.expect(PutKeyValueCommand.class);
        tm1.begin();
        cache1.putForExternalRead((Object)"k", (Object)"v");
        tm1.commit();
        replListener2.waitForRpc();
        final TransactionTable tt1 = TestingUtil.extractComponent(cache1, TransactionTable.class);
        final TransactionTable tt2 = TestingUtil.extractComponent(cache2, TransactionTable.class);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0;
            }
        });
        replListener2.expectWithTx(PutKeyValueCommand.class);
        tm1.begin();
        AssertJUnit.assertEquals((int)tm1.getTransaction().getStatus(), (int)0);
        cache1.putForExternalRead((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)tm1.getTransaction().getStatus(), (int)0);
        cache1.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)tm1.getTransaction().getStatus(), (int)0);
        this.log.info((Object)"Before commit!!");
        tm1.commit();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0;
            }
        });
        replListener2.expectWithTx(PutKeyValueCommand.class);
        tm1.begin();
        cache1.put((Object)"k", (Object)"v");
        cache1.putForExternalRead((Object)"k", (Object)"v");
        tm1.commit();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0;
            }
        });
        replListener2.expectWithTx(PutKeyValueCommand.class, PutKeyValueCommand.class);
        tm1.begin();
        cache1.put((Object)"k", (Object)"v");
        cache1.putForExternalRead((Object)"k", (Object)"v");
        cache1.put((Object)"k", (Object)"v");
        tm1.commit();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return tt1.getRemoteTxCount() == 0 && tt1.getLocalTxCount() == 0 && tt2.getRemoteTxCount() == 0 && tt2.getLocalTxCount() == 0;
            }
        });
    }

    public void testMultipleIdenticalPutForExternalReadCalls() {
        Cache cache1 = this.cache(0, "replSync");
        cache1.putForExternalRead((Object)"k", (Object)"v");
        cache1.putForExternalRead((Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((String)"v", (String)((String)cache1.get((Object)"k")));
    }

    private void cacheModeLocalTest(boolean transactional, Method m) throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        TransactionManager tm1 = TestingUtil.getTransactionManager(cache1);
        if (transactional) {
            tm1.begin();
        }
        String k = TestingUtil.k(m);
        cache1.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).putForExternalRead((Object)k, (Object)TestingUtil.v(m));
        AssertJUnit.assertFalse((boolean)cache2.containsKey((Object)k));
        if (transactional) {
            tm1.commit();
        }
    }
}

