/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.QueryableDataContainer;
import org.infinispan.interceptors.IsMarshallableInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.ConfigurationOverridesTest")
public class ConfigurationOverridesTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigOverrides() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Configuration c = new Configuration().fluent().clustering().hash().versioning().enable().build();
            Configuration c2 = cm.defineConfiguration("a", c);
            assert (c2.isEnableVersioning());
            c = new Configuration().fluent().dataContainer().dataContainerClass(QueryableDataContainer.class).build();
            c2 = cm.defineConfiguration("b", c);
            assert (c2.getDataContainerClass().equals(QueryableDataContainer.class.getName()));
            IsMarshallableInterceptor intercept = new IsMarshallableInterceptor();
            c = new Configuration().fluent().customInterceptors().add((CommandInterceptor)intercept).last().build();
            c2 = cm.defineConfiguration("c", c);
            List intercepts = c2.getCustomInterceptors();
            assert (intercepts.size() == 1);
            assert (((CustomInterceptorConfig)intercepts.get(0)).getInterceptor().equals(intercept));
        }
        finally {
            cm.stop();
        }
    }
}

