/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.config.parsing.ConfigFilesConvertor;
import org.infinispan.config.parsing.Jbc2InfinispanTransformerTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.parsing.EHCache2InfinispanTransformerTest")
public class EHCache2InfinispanTransformerTest
extends AbstractInfinispanTest {
    private static final String BASE_DIR = "configs/ehcache";
    ConfigFilesConvertor convertor = new ConfigFilesConvertor();

    public void testEhCache16File() throws Exception {
        this.testAllFile("/ehcache-1.6.xml");
    }

    public void testEhCache15File() throws Exception {
        this.testAllFile("/ehcache-1.5.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAllFile(String ehCacheFile) throws Exception {
        ClassLoader existingCl = Thread.currentThread().getContextClassLoader();
        DefaultCacheManager dcm = null;
        Cache sampleDistributedCache2 = null;
        try {
            Jbc2InfinispanTransformerTest.TestClassLoader delegatingCl = new Jbc2InfinispanTransformerTest.TestClassLoader(existingCl);
            Thread.currentThread().setContextClassLoader(delegatingCl);
            String fileName = this.getFileName(ehCacheFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.convertor.parse(fileName, (OutputStream)baos, (String)ConfigFilesConvertor.TRANSFORMATIONS.get("Ehcache1x"), Thread.currentThread().getContextClassLoader());
            dcm = (DefaultCacheManager)TestCacheManagerFactory.fromStream(new ByteArrayInputStream(baos.toByteArray()));
            Cache defaultCache = dcm.getCache();
            defaultCache.put((Object)"key", (Object)"value");
            Configuration configuration = defaultCache.getCacheConfiguration();
            Assert.assertEquals((int)configuration.eviction().maxEntries(), (int)10000);
            Assert.assertEquals((long)configuration.expiration().maxIdle(), (long)121L);
            Assert.assertEquals((long)configuration.expiration().lifespan(), (long)122L);
            LoadersConfiguration loaders = configuration.loaders();
            assert (loaders.cacheLoaders().get(0) instanceof FileCacheStoreConfiguration);
            Assert.assertEquals((long)configuration.expiration().wakeUpInterval(), (long)119000L);
            Assert.assertEquals((Object)configuration.eviction().strategy(), (Object)EvictionStrategy.LRU);
            String definedCacheNames = dcm.getDefinedCacheNames();
            assert (definedCacheNames.contains("sampleCache1"));
            assert (definedCacheNames.contains("sampleCache2"));
            assert (definedCacheNames.contains("sampleCache3"));
            assert (definedCacheNames.contains("sampleDistributedCache1"));
            assert (definedCacheNames.contains("sampleDistributedCache2"));
            assert (definedCacheNames.contains("sampleDistributedCache3"));
            sampleDistributedCache2 = dcm.getCache("sampleDistributedCache2");
            Configuration configuration2 = sampleDistributedCache2.getCacheConfiguration();
            assert (configuration2.loaders().cacheLoaders().size() == 1);
            assert (configuration2.expiration().lifespan() == 101L);
            assert (configuration2.expiration().maxIdle() == 102L);
            Assert.assertEquals((Object)configuration2.clustering().cacheMode(), (Object)CacheMode.INVALIDATION_SYNC);
            Thread.currentThread().setContextClassLoader(existingCl);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(existingCl);
            TestingUtil.killCaches(sampleDistributedCache2);
            TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{dcm});
            throw throwable;
        }
        TestingUtil.killCaches(sampleDistributedCache2);
        TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{dcm});
    }

    private String getFileName(String s) {
        return BASE_DIR + File.separator + s;
    }
}

