/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.as;

import java.io.IOException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="configuration.as.ASXmlFileParsingTest")
public class ASXmlFileParsingTest
extends AbstractInfinispanTest {
    public void testNamedCacheFile() throws IOException {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.fromXml("configs/as7/standalone.xml")){

            @Override
            public void call() {
                Configuration c = this.cm.getCacheConfiguration("default");
                assert (c.clustering().cacheMode().equals((Object)CacheMode.LOCAL));
                assert (c.locking().isolationLevel().equals((Object)IsolationLevel.NONE));
                assert (c.locking().lockAcquisitionTimeout() == 30000L);
                assert (c.locking().concurrencyLevel() == 1000);
                assert (!c.locking().useLockStriping());
                assert (c.transaction().transactionMode().equals((Object)TransactionMode.NON_TRANSACTIONAL));
                assert (c.eviction().strategy().equals((Object)EvictionStrategy.LRU));
                assert (c.eviction().maxEntries() == 1000);
                assert (c.expiration().lifespan() == 2000L);
                assert (c.expiration().maxIdle() == 1000L);
                assert (c.loaders().passivation());
                assert (!c.loaders().shared());
                assert (c.loaders().cacheLoaders().size() == 1);
                FileCacheStoreConfiguration fcsc = (FileCacheStoreConfiguration)c.loaders().cacheLoaders().get(0);
                assert (fcsc.purgeOnStartup());
                assert (fcsc.location().equals("nc"));
                assert (fcsc.async().enabled());
                assert (fcsc.async().flushLockTimeout() == 1L);
                assert (fcsc.async().modificationQueueSize() == 1024);
                assert (fcsc.async().shutdownTimeout() == 25000L);
                assert (fcsc.async().threadPoolSize() == 1);
                c = this.cm.getCacheConfiguration("distsync");
                assert (c.clustering().cacheMode().equals((Object)CacheMode.DIST_SYNC));
                assert (c.locking().isolationLevel().equals((Object)IsolationLevel.READ_COMMITTED));
                assert (c.locking().lockAcquisitionTimeout() == 20000L);
                assert (c.locking().concurrencyLevel() == 500);
                assert (c.locking().useLockStriping());
                assert (c.transaction().recovery().enabled());
                assert (c.eviction().strategy().equals((Object)EvictionStrategy.LIRS));
                assert (c.eviction().maxEntries() == 1000);
            }
        });
    }
}

