/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.versioning.AbstractClusteredWriteSkewTest;
import org.infinispan.context.Flag;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(testName="container.versioning.ReplWriteSkewTest", groups={"functional"})
@CleanupAfterMethod
public class ReplWriteSkewTest
extends AbstractClusteredWriteSkewTest {
    @Override
    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    public void testWriteSkew() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        cache0.put((Object)"hello", (Object)"world 1");
        this.tm(0).begin();
        assert ("world 1".equals(cache0.get((Object)"hello")));
        Transaction t = this.tm(0).suspend();
        cache1.put((Object)"hello", (Object)"world 3");
        assert (cache0.get((Object)"hello").equals("world 3"));
        assert (cache1.get((Object)"hello").equals("world 3"));
        this.tm(0).resume(t);
        cache0.put((Object)"hello", (Object)"world 2");
        try {
            this.tm(0).commit();
            assert (false) : "Transaction should roll back";
        }
        catch (RollbackException re) {
            // empty catch block
        }
        assert ("world 3".equals(cache0.get((Object)"hello")));
        assert ("world 3".equals(cache1.get((Object)"hello")));
    }

    public void testWriteSkewMultiEntries() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        this.tm(0).begin();
        cache0.put((Object)"hello", (Object)"world 1");
        cache0.put((Object)"hello2", (Object)"world 1");
        this.tm(0).commit();
        this.tm(0).begin();
        cache0.put((Object)"hello2", (Object)"world 2");
        assert ("world 2".equals(cache0.get((Object)"hello2")));
        assert ("world 1".equals(cache0.get((Object)"hello")));
        Transaction t = this.tm(0).suspend();
        cache1.put((Object)"hello", (Object)"world 3");
        assert (cache0.get((Object)"hello").equals("world 3"));
        assert (cache0.get((Object)"hello2").equals("world 1"));
        assert (cache1.get((Object)"hello").equals("world 3"));
        assert (cache1.get((Object)"hello2").equals("world 1"));
        this.tm(0).resume(t);
        cache0.put((Object)"hello", (Object)"world 2");
        try {
            this.tm(0).commit();
            assert (false) : "Transaction should roll back";
        }
        catch (RollbackException re) {
            // empty catch block
        }
        assert (cache0.get((Object)"hello").equals("world 3"));
        assert (cache0.get((Object)"hello2").equals("world 1"));
        assert (cache1.get((Object)"hello").equals("world 3"));
        assert (cache1.get((Object)"hello2").equals("world 1"));
    }

    public void testNullEntries() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        cache0.put((Object)"hello", (Object)"world");
        this.tm(0).begin();
        assert ("world".equals(cache0.get((Object)"hello")));
        Transaction t = this.tm(0).suspend();
        cache1.remove((Object)"hello");
        assert (null == cache0.get((Object)"hello"));
        assert (null == cache1.get((Object)"hello"));
        this.tm(0).resume(t);
        cache0.put((Object)"hello", (Object)"world2");
        try {
            this.tm(0).commit();
            assert (false) : "This transaction should roll back";
        }
        catch (RollbackException expected) {
            // empty catch block
        }
        assert (null == cache0.get((Object)"hello"));
        assert (null == cache1.get((Object)"hello"));
    }

    public void testResendPrepare() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        cache0.put((Object)"hello", (Object)"world");
        this.tm(0).begin();
        assert ("world".equals(cache0.get((Object)"hello")));
        Transaction t = this.tm(0).suspend();
        this.cache(0).put((Object)"hello", (Object)"world2");
        assert ("world2".equals(cache0.get((Object)"hello")));
        assert ("world2".equals(cache1.get((Object)"hello")));
        this.tm(0).resume(t);
        cache0.put((Object)"hello", (Object)"world3");
        try {
            this.log.warn((Object)"----- Now committing ---- ");
            this.tm(0).commit();
            assert (false) : "This transaction should roll back";
        }
        catch (RollbackException expected) {
            expected.printStackTrace();
        }
        assert ("world2".equals(cache0.get((Object)"hello")));
        assert ("world2".equals(cache1.get((Object)"hello")));
    }

    public void testLocalOnlyPut() {
        this.localOnlyPut(this.cache(0), 1, "v1");
        this.localOnlyPut(this.cache(1), 2, "v2");
    }

    @Override
    @Test(enabled=false, description="See ISPN-2160")
    public void testSharedCounter() {
        super.testSharedCounter();
    }

    private void localOnlyPut(Cache<Integer, String> cache, Integer k, String v) {
        cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)k, (Object)v);
    }
}

