/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.distexec.LocalDistributedExecutorTest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.DistributedExecutorTest")
public class DistributedExecutorTest
extends LocalDistributedExecutorTest {
    public static AtomicInteger counter = new AtomicInteger();
    protected boolean supportsConcurrentUpdates = true;

    public DistributedExecutorTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = DistributedExecutorTest.getDefaultClusteredCacheConfig(this.getCacheMode(), false);
        builder.locking().supportsConcurrentUpdates(this.supportsConcurrentUpdates);
        this.createClusteredCaches(2, this.cacheName(), builder);
    }

    @Override
    protected String cacheName() {
        return "DistributedExecutorTest-DIST_SYNC";
    }

    @Override
    protected CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    @Override
    protected Cache<Object, Object> getCache() {
        return this.cache(0, this.cacheName());
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testBasicTargetLocalDistributedCallableWithTimeout() throws Exception {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        builder.timeout(1000L, TimeUnit.MILLISECONDS);
        Future future = des.submit(target, builder.build());
        future.get();
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testBasicTargetRemoteDistributedCallableWithException() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        Cache cache2 = this.cache(1, this.cacheName());
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache2.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.ExceptionThrowingCallable());
        Future future = des.submit(target, builder.build());
        future.get();
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testBasicTargetLocalDistributedCallableWithHighFutureAndLowTaskTimeout() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        builder.timeout(1000L, TimeUnit.MILLISECONDS);
        Future future = des.submit(target, builder.build());
        future.get(10000L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testBasicTargetLocalDistributedCallableWithLowFutureAndHighTaskTimeout() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        builder.timeout(10000L, TimeUnit.MILLISECONDS);
        Future future = des.submit(target, builder.build());
        future.get(1000L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testBasicTargetRemoteDistributedCallableWithHighFutureAndLowTaskTimeout() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        Cache cache2 = this.cache(1, this.cacheName());
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache2.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        builder.timeout(1000L, TimeUnit.MILLISECONDS);
        Future future = des.submit(target, builder.build());
        future.get(10000L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testBasicTargetRemoteDistributedCallableWithLowFutureAndHighTaskTimeout() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        Cache cache2 = this.cache(1, this.cacheName());
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache2.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        builder.timeout(10000L, TimeUnit.MILLISECONDS);
        Future future = des.submit(target, builder.build());
        future.get(1000L, TimeUnit.MILLISECONDS);
    }

    public void testBasicTargetLocalDistributedCallableWithoutSpecTimeout() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        Future future = des.submit(target, builder.build());
        AssertJUnit.assertEquals((Object)1, future.get());
    }

    public void testTaskCancellation() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        List cacheMembers = this.getCache().getAdvancedCache().getRpcManager().getMembers();
        ArrayList members = new ArrayList(cacheMembers);
        AssertJUnit.assertEquals((int)this.caches(this.cacheName()).size(), (int)members.size());
        members.remove(this.getCache().getAdvancedCache().getRpcManager().getAddress());
        DistributedTaskBuilder tb = des.createDistributedTaskBuilder((Callable)new LongRunningCallable());
        Future future = des.submit((Address)members.get(0), tb.build());
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return counter.get() >= 1;
            }
        });
        future.cancel(true);
        boolean taskCancelled = false;
        try {
            future.get();
        }
        catch (Exception e) {
            taskCancelled = e instanceof CancellationException;
        }
        assert (taskCancelled) : "Dist task not cancelled ";
        assert (counter.get() >= 2);
        assert (future.isCancelled());
        assert (future.isDone());
        boolean isCanceled = future.cancel(true);
        assert (!isCanceled);
    }

    @Test(expectedExceptions={CancellationException.class})
    public void testCancelAndGet() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        List cacheMembers = this.getCache().getAdvancedCache().getRpcManager().getMembers();
        ArrayList members = new ArrayList(cacheMembers);
        AssertJUnit.assertEquals((int)this.caches(this.cacheName()).size(), (int)members.size());
        members.remove(this.getCache().getAdvancedCache().getRpcManager().getAddress());
        DistributedTaskBuilder tb = des.createDistributedTaskBuilder((Callable)new LongRunningCallable());
        Future future = des.submit((Address)members.get(0), tb.build());
        future.cancel(true);
        future.get();
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testTimeoutOnLocalNode() throws Exception {
        AdvancedCache localCache = this.getCache().getAdvancedCache();
        DistributedExecutorService des = this.createDES((Cache<?, ?>)localCache);
        Future future = des.submit(localCache.getRpcManager().getAddress(), (Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        future.get(2000L, TimeUnit.MILLISECONDS);
    }

    public void testBasicTargetDistributedCallableTargetSameNode() throws Exception {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        Future future = des.submit(target, (Callable)((Object)new LocalDistributedExecutorTest.SimpleDistributedCallable(false)));
        Boolean r = (Boolean)future.get();
        assert (r.booleanValue());
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new LocalDistributedExecutorTest.SimpleDistributedCallable(false)));
        DistributedTask distributedTask = taskBuilder.build();
        future = des.submit(target, distributedTask);
        r = (Boolean)future.get();
        assert (r.booleanValue());
    }

    public void testBasicTargetDistributedCallable() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        Cache cache2 = this.cache(1, this.cacheName());
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache2.getAdvancedCache().getRpcManager().getAddress();
        Future future = des.submit(target, (Callable)((Object)new LocalDistributedExecutorTest.SimpleDistributedCallable(false)));
        Boolean r = (Boolean)future.get();
        assert (r.booleanValue());
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new LocalDistributedExecutorTest.SimpleDistributedCallable(false)));
        DistributedTask distributedTask = taskBuilder.build();
        future = des.submit(target, distributedTask);
        r = (Boolean)future.get();
        assert (r.booleanValue());
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testBasicTargetDistributedCallableWithTimeout() throws Exception {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
        builder.timeout(10L, TimeUnit.MILLISECONDS);
        Future future = des.submit(target, builder.build());
        future.get();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testBasicTargetCallableWithNullTask() {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        des.submit(target, (Callable)null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicTargetDistributedTaskWithNullTask() {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
        des.submit(target, (DistributedTask)null);
    }

    public void testDistributedCallableEverywhereWithKeysOnBothNodes() throws Exception {
        Cache<Object, Object> c1 = this.getCache();
        c1.put((Object)"key1", (Object)"Manik");
        c1.put((Object)"key2", (Object)"Mircea");
        c1.put((Object)"key3", (Object)"Galder");
        c1.put((Object)"key4", (Object)"Sanne");
        Cache c2 = this.cache(1, this.cacheName());
        c2.put((Object)"key5", (Object)"test");
        c2.put((Object)"key6", (Object)"test1");
        DistributedExecutorService des = this.createDES(this.getCache());
        List list = des.submitEverywhere((Callable)((Object)new LocalDistributedExecutorTest.SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2", "key5", "key6"});
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new LocalDistributedExecutorTest.SimpleDistributedCallable(true)));
        DistributedTask distributedTask = taskBuilder.build();
        list = des.submitEverywhere(distributedTask, (Object[])new String[]{"key1", "key2"});
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
    }

    static class LongRunningCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -6110011263261397071L;

        LongRunningCallable() {
        }

        @Override
        public Integer call() throws Exception {
            CountDownLatch latch = new CountDownLatch(1);
            counter.incrementAndGet();
            try {
                latch.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                counter.incrementAndGet();
            }
            return 1;
        }
    }
}

