/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distexec.DistributedExecutorTest;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.ReplSyncDistributedExecutorTest")
public class ReplSyncDistributedExecutorTest
extends DistributedExecutorTest {
    public static AtomicInteger ReplSyncDistributedExecutorTestCancelCounter = new AtomicInteger();

    public ReplSyncDistributedExecutorTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected String cacheName() {
        return "DistributedExecutorTest-REPL_SYNC";
    }

    @Override
    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    @Override
    public void testTaskCancellation() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        List l = this.getCache().getAdvancedCache().getRpcManager().getMembers();
        ArrayList members = new ArrayList(l);
        members.remove(this.getCache().getAdvancedCache().getRpcManager().getAddress());
        DistributedTaskBuilder tb = des.createDistributedTaskBuilder((Callable)new MyLongRunningCallable());
        Future future = des.submit((Address)members.get(0), tb.build());
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return ReplSyncDistributedExecutorTestCancelCounter.get() >= 1;
            }
        });
        future.cancel(true);
        boolean taskCancelled = false;
        try {
            future.get();
        }
        catch (Exception e) {
            taskCancelled = e instanceof CancellationException;
        }
        assert (taskCancelled) : "Dist task not cancelled";
        assert (ReplSyncDistributedExecutorTestCancelCounter.get() >= 2);
        assert (future.isCancelled());
        assert (future.isDone());
        boolean canceled = future.cancel(true);
        assert (!canceled);
    }

    static class MyLongRunningCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -6110011263261397071L;

        MyLongRunningCallable() {
        }

        @Override
        public Integer call() throws Exception {
            CountDownLatch latch = new CountDownLatch(1);
            ReplSyncDistributedExecutorTestCancelCounter.incrementAndGet();
            try {
                latch.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                ReplSyncDistributedExecutorTestCancelCounter.incrementAndGet();
            }
            return 1;
        }
    }
}

