/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ObjectDuplicator;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncFuncTest")
public class DistSyncFuncTest
extends BaseDistFunctionalTest {
    public DistSyncFuncTest() {
        this.sync = true;
        this.tx = false;
        this.testRetVals = true;
    }

    public void testLocationConsensus() {
        String[] keys = new String[100];
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            keys[i] = Integer.toHexString(r.nextInt());
        }
        for (String key : keys) {
            ArrayList<Address> owners = new ArrayList<Address>();
            for (Cache c : this.caches) {
                boolean isOwner = this.isOwner(c, key);
                if (isOwner) {
                    owners.add(this.addressOf(c));
                }
                boolean secondCheck = this.getConsistentHash(c).locateOwners((Object)key).contains(this.addressOf(c));
                assert (isOwner == secondCheck) : "Second check failed for key " + key + " on cache " + this.addressOf(c) + " isO = " + isOwner + " sC = " + secondCheck;
            }
            this.assertOwnershipConsensus(key);
            assert (owners.size() == 2) : "Expected 2 owners for key " + key + " but was " + owners;
        }
    }

    private void assertOwnershipConsensus(String key) {
        List l1 = this.getConsistentHash(this.c1).locateOwners((Object)key);
        List l2 = this.getConsistentHash(this.c2).locateOwners((Object)key);
        List l3 = this.getConsistentHash(this.c3).locateOwners((Object)key);
        List l4 = this.getConsistentHash(this.c4).locateOwners((Object)key);
        assert (l1.equals(l2)) : "L1 " + l1 + " and L2 " + l2 + " don't agree.";
        assert (l2.equals(l3)) : "L2 " + l2 + " and L3 " + l3 + " don't agree.";
        assert (l3.equals(l4)) : "L3 " + l3 + " and L4 " + l4 + " don't agree.";
    }

    public void testBasicDistribution() throws Throwable {
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Object k1 = this.getKeyForCache((Cache)this.caches.get(1));
        this.getOwners(k1)[0].put(k1, (Object)"value");
        this.asyncWait(k1, PutKeyValueCommand.class, new Cache[0]);
        for (Cache c : this.caches) {
            if (this.isOwner(c, k1)) {
                this.assertIsInContainerImmortal(c, k1);
                continue;
            }
            this.assertIsNotInL1(c, k1);
        }
        this.assertOnAllCachesAndOwnership(k1, "value");
        for (Cache c : this.caches) {
            if (this.isOwner(c, k1)) {
                this.assertIsInContainerImmortal(c, k1);
                continue;
            }
            this.assertIsInL1(c, k1);
        }
    }

    public void testPutFromNonOwner() {
        this.initAndTest();
        Cache<Object, String> nonOwner = this.getFirstNonOwner("k1");
        Object retval = nonOwner.put((Object)"k1", (Object)"value2");
        this.asyncWait("k1", PutKeyValueCommand.class, this.getSecondNonOwner("k1"));
        if (this.testRetVals) assert ("value".equals(retval));
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }

    public void testPutIfAbsentFromNonOwner() {
        this.initAndTest();
        this.log.trace((Object)"Here it begins");
        Object retval = this.getFirstNonOwner("k1").putIfAbsent((Object)"k1", (Object)"value2");
        if (this.testRetVals) assert ("value".equals(retval));
        this.assertOnAllCachesAndOwnership("k1", "value");
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class, new Cache[0]);
        retval = this.getFirstNonOwner("k1").putIfAbsent((Object)"k1", (Object)"value2");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                try {
                    DistSyncFuncTest.this.assertOnAllCachesAndOwnership("k1", "value2");
                }
                catch (AssertionError e) {
                    return false;
                }
                return true;
            }
        });
        if (this.testRetVals) assert (null == retval);
    }

    public void testRemoveFromNonOwner() {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").remove((Object)"k1");
        this.asyncWait("k1", RemoveCommand.class, this.getSecondNonOwner("k1"));
        if (this.testRetVals) assert ("value".equals(retval));
        this.assertRemovedOnAllCaches("k1");
    }

    public void testConditionalRemoveFromNonOwner() {
        this.initAndTest();
        this.log.trace((Object)"Here we start");
        boolean retval = this.getFirstNonOwner("k1").remove((Object)"k1", (Object)"value2");
        if (this.testRetVals) assert (!retval) : "Should not have removed entry";
        this.assertOnAllCachesAndOwnership("k1", "value");
        assert (((String)((Cache)this.caches.get(1)).get((Object)"k1")).equals("value"));
        Cache<Object, String> owner = this.getFirstNonOwner("k1");
        retval = owner.remove((Object)"k1", (Object)"value");
        this.asyncWait("k1", RemoveCommand.class, this.getSecondNonOwner("k1"));
        if (this.testRetVals) assert (retval) : "Should have removed entry";
        assert (((Cache)this.caches.get(1)).get((Object)"k1") == null) : "expected null but received " + (String)((Cache)this.caches.get(1)).get((Object)"k1");
        this.assertRemovedOnAllCaches("k1");
    }

    public void testReplaceFromNonOwner() {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").replace((Object)"k1", (Object)"value2");
        if (this.testRetVals) assert ("value".equals(retval));
        this.asyncWait("k1", ReplaceCommand.class, this.getSecondNonOwner("k1"));
        this.assertOnAllCachesAndOwnership("k1", "value2");
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class, new Cache[0]);
        retval = this.getFirstNonOwner("k1").replace((Object)"k1", (Object)"value2");
        if (this.testRetVals) assert (retval == null);
        this.assertRemovedOnAllCaches("k1");
    }

    public void testConditionalReplaceFromNonOwner() {
        this.initAndTest();
        Cache<Object, String> nonOwner = this.getFirstNonOwner("k1");
        boolean retval = nonOwner.replace((Object)"k1", (Object)"valueX", (Object)"value2");
        if (this.testRetVals) assert (!retval) : "Should not have replaced";
        this.assertOnAllCachesAndOwnership("k1", "value");
        assert (!((DistributionManager)nonOwner.getAdvancedCache().getComponentRegistry().getComponent(DistributionManager.class)).getLocality((Object)"k1").isLocal());
        retval = nonOwner.replace((Object)"k1", (Object)"value", (Object)"value2");
        this.asyncWait("k1", ReplaceCommand.class, this.getSecondNonOwner("k1"));
        if (this.testRetVals) assert (retval) : "Should have replaced";
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }

    public void testClear() throws InterruptedException {
        int i;
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        for (i = 0; i < 10; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
            this.asyncWait("k" + i, PutKeyValueCommand.class, new Cache[0]);
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (i = 0; i < 10; ++i) {
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (Cache c : this.caches) {
            assert (!c.isEmpty());
        }
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class, new Cache[0]);
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
    }

    public void testKeyValueEntryCollections() {
        this.c1.put((Object)"1", (Object)"one");
        this.asyncWait("1", PutKeyValueCommand.class, new Cache[0]);
        this.c2.put((Object)"2", (Object)"two");
        this.asyncWait("2", PutKeyValueCommand.class, new Cache[0]);
        this.c3.put((Object)"3", (Object)"three");
        this.asyncWait("3", PutKeyValueCommand.class, new Cache[0]);
        this.c4.put((Object)"4", (Object)"four");
        this.asyncWait("4", PutKeyValueCommand.class, new Cache[0]);
        for (Cache c : this.caches) {
            Set expKeys = TestingUtil.getInternalKeys(c);
            Collection expValues = TestingUtil.getInternalValues(c);
            Set expKeyEntries = ObjectDuplicator.duplicateSet((Set)expKeys);
            Collection expValueEntries = ObjectDuplicator.duplicateCollection((Collection)expValues);
            Set keys = c.keySet();
            for (Object key : keys) {
                assert (expKeys.remove(key));
            }
            assert (expKeys.isEmpty()) : "Did not see keys " + expKeys + " in iterator!";
            Collection values = c.values();
            for (Object value : values) {
                assert (expValues.remove(value));
            }
            assert (expValues.isEmpty()) : "Did not see keys " + expValues + " in iterator!";
            Set entries = c.entrySet();
            for (Map.Entry entry : entries) {
                assert (expKeyEntries.remove(entry.getKey()));
                assert (expValueEntries.remove(entry.getValue()));
            }
            assert (expKeyEntries.isEmpty()) : "Did not see keys " + expKeyEntries + " in iterator!";
            assert (expValueEntries.isEmpty()) : "Did not see keys " + expValueEntries + " in iterator!";
        }
    }
}

