/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collections;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.InvalidationNoReplicationTest")
public class InvalidationNoReplicationTest
extends MultipleCacheManagersTest {
    protected Object k0;
    protected boolean transactional = true;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration config = InvalidationNoReplicationTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, this.transactional);
        config.setL1CacheEnabled(true);
        config.setNumOwners(1);
        this.createCluster(config, 2);
        this.waitForClusterToForm();
        this.k0 = this.getKeyForCache(0);
    }

    public void testInvalidation() throws Exception {
        assert (this.advancedCache(0).getDistributionManager().locate(this.k0).equals(Collections.singletonList(this.address(0))));
        assert (this.advancedCache(1).getDistributionManager().locate(this.k0).equals(Collections.singletonList(this.address(0))));
        this.advancedCache(1).put(this.k0, (Object)"k1");
        assert (this.advancedCache(1).getDataContainer().containsKey(this.k0));
        assert (this.advancedCache(0).getDataContainer().containsKey(this.k0));
        this.tm(0).begin();
        this.cache(0).put(this.k0, (Object)"v2");
        this.tm(0).commit();
        assert (!this.advancedCache(1).getDataContainer().containsKey(this.k0));
    }
}

