/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.PessimisticDistSyncTxCacheStoreSharedTest")
public class PessimisticDistSyncTxCacheStoreSharedTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder getCB() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).sync().replTimeout(60000L).stateTransfer().timeout(180000L).fetchInMemoryState(true).hash().numOwners(1);
        cb.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).syncCommitPhase(true).syncRollbackPhase(true);
        cb.loaders().passivation(false).preload(true).shared(true);
        LegacyStoreConfigurationBuilder sb = cb.loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore());
        sb.addProperty("storeName", this.getClass().getSimpleName());
        sb.async().disable();
        return cb;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(this.getCB(), 1);
        this.waitForClusterToForm();
    }

    @Test
    public void testInvalidPut() throws Exception {
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("P006");
        for (int i = 0; i < 4; ++i) {
            cache.put((Object)(((EmbeddedCacheManager)this.cacheManagers.get(0)).getAddress().toString() + "-" + i), (Object)"42");
        }
        CacheStore cs1 = ((CacheLoaderManager)cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        Set keys = cs1.loadAllKeys(null);
        Assert.assertEquals((int)keys.size(), (int)4);
        this.addClusterEnabledCacheManager(this.getCB());
        this.waitForClusterToForm("P006");
        cache = ((EmbeddedCacheManager)this.cacheManagers.get(1)).getCache("P006");
        for (int i = 0; i < 4; ++i) {
            cache.put((Object)(((EmbeddedCacheManager)this.cacheManagers.get(1)).getAddress().toString() + "-" + i), (Object)"42");
        }
        HashSet mergedKeys = new HashSet();
        CacheStore cs2 = ((CacheLoaderManager)cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        this.log.debugf("Load from cache store via cache 1", new Object[0]);
        mergedKeys.addAll(cs1.loadAllKeys(null));
        this.log.debugf("Load from cache store via cache 2", new Object[0]);
        mergedKeys.addAll(cs2.loadAllKeys(null));
        Assert.assertEquals((int)mergedKeys.size(), (int)8);
    }
}

