/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.SingleOwnerAndAsyncMethodsWithTxTest")
public class SingleOwnerAndAsyncMethodsWithTxTest
extends BaseDistFunctionalTest {
    public SingleOwnerAndAsyncMethodsWithTxTest() {
        this.INIT_CLUSTER_SIZE = 2;
        this.numOwners = 1;
        this.sync = true;
        this.tx = true;
        this.l1CacheEnabled = true;
        this.lockTimeout = 5;
        this.lockingMode = LockingMode.PESSIMISTIC;
    }

    public void testAsyncGetsWithinTx(Method m) throws Exception {
        String k = TestingUtil.k(m);
        String v = TestingUtil.v(m);
        Cache<Object, String> ownerCache = this.getOwner(k);
        Cache<Object, String> nonOwnerCache = this.getNonOwner(k);
        ownerCache.put((Object)k, (Object)v);
        TransactionManager tm = this.getTransactionManager(nonOwnerCache);
        tm.begin();
        NotifyingFuture f = nonOwnerCache.getAsync((Object)k);
        assert (f != null);
        assert (((String)f.get()).equals(v));
        nonOwnerCache.put((Object)k, (Object)TestingUtil.v(m, 2));
        tm.commit();
        f = nonOwnerCache.getAsync((Object)k);
        assert (f != null);
        assert (((String)f.get()).equals(TestingUtil.v(m, 2)));
    }

    public void testAsyncGetToL1AndConcurrentModification(Method m) throws Throwable {
        this.modifyConcurrently(m, this.getNonOwner(TestingUtil.k(m)), false);
    }

    public void testAsyncGetWithForceWriteLockFlag(Method m) throws Throwable {
        this.modifyConcurrently(m, this.getOwner(TestingUtil.k(m)), true);
    }

    private void modifyConcurrently(final Method m, final Cache cache, final boolean withFlag) throws Throwable {
        block4: {
            final String k = TestingUtil.k(m);
            final String v = TestingUtil.v(m);
            Cache<Object, String> ownerCache = this.getOwner(k);
            ownerCache.put((Object)k, (Object)v);
            final CountDownLatch getAsynclatch = new CountDownLatch(1);
            final CountDownLatch putLatch = new CountDownLatch(1);
            ExecutorService exec = Executors.newCachedThreadPool();
            Callable<Void> c1 = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Cache localCache = cache;
                    TransactionManager tm = SingleOwnerAndAsyncMethodsWithTxTest.this.getTransactionManager(localCache);
                    tm.begin();
                    if (withFlag) {
                        localCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK});
                    }
                    NotifyingFuture f = localCache.getAsync((Object)k);
                    assert (f != null);
                    assert (((String)f.get()).equals(v));
                    putLatch.countDown();
                    getAsynclatch.await();
                    tm.commit();
                    return null;
                }
            };
            Callable<Void> c2 = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    putLatch.await();
                    TransactionManager tm = SingleOwnerAndAsyncMethodsWithTxTest.this.getTransactionManager(cache);
                    tm.begin();
                    try {
                        cache.put((Object)k, (Object)TestingUtil.v(m, 1));
                        getAsynclatch.countDown();
                        assert (!withFlag) : "Put operation should have timed out if the get operation acquires a write lock";
                    }
                    catch (TimeoutException e) {
                        tm.setRollbackOnly();
                        getAsynclatch.countDown();
                        throw e;
                    }
                    finally {
                        if (tm.getStatus() == 0) {
                            tm.commit();
                        } else {
                            tm.rollback();
                        }
                    }
                    return null;
                }
            };
            Future<Void> f1 = exec.submit(c1);
            Future<Void> f2 = exec.submit(c2);
            f1.get();
            try {
                f2.get();
                assert (!withFlag) : "Should throw a TimeoutException if the get operation acquired a lock";
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AssertionError) {
                    throw cause;
                }
                if ($assertionsDisabled || e.getCause() instanceof TimeoutException) break block4;
                throw new AssertionError((Object)String.format("The exception should be a TimeoutException but instead was %s", e.getCause()));
            }
        }
    }

    protected Cache<Object, String> getOwner(Object key) {
        return this.getOwners(key)[0];
    }

    protected Cache<Object, String> getNonOwner(Object key) {
        return this.getNonOwners(key)[0];
    }

    @Override
    public Cache<Object, String>[] getOwners(Object key) {
        return this.getOwners(key, 1);
    }

    @Override
    public Cache<Object, String>[] getNonOwners(Object key) {
        return this.getNonOwners(key, 1);
    }
}

