/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.Collection;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.OwnershipStatistics;
import org.infinispan.distribution.topologyaware.TopologyInfo;
import org.infinispan.remoting.transport.Address;

class TopologyAwareOwnershipStatistics {
    private final DefaultConsistentHash ch;
    TopologyInfo topologyInfo;
    OwnershipStatistics stats;

    public TopologyAwareOwnershipStatistics(DefaultConsistentHash ch) {
        this.ch = ch;
        this.topologyInfo = new TopologyInfo((Collection)ch.getMembers());
        this.stats = new OwnershipStatistics(ch, ch.getMembers());
    }

    public int getSiteOwned(String site) {
        int count = 0;
        for (Address node : this.topologyInfo.getSiteNodes(site)) {
            count += this.stats.getOwned(node);
        }
        return count;
    }

    public int getSitePrimaryOwned(String site) {
        int count = 0;
        for (Address node : this.topologyInfo.getSiteNodes(site)) {
            count += this.stats.getPrimaryOwned(node);
        }
        return count;
    }

    public int getRackOwned(String site, String rack) {
        int count = 0;
        for (Address node : this.topologyInfo.getRackNodes(site, rack)) {
            count += this.stats.getOwned(node);
        }
        return count;
    }

    public int getRackPrimaryOwned(String site, String rack) {
        int count = 0;
        for (Address node : this.topologyInfo.getRackNodes(site, rack)) {
            count += this.stats.getPrimaryOwned(node);
        }
        return count;
    }

    public int getMachineOwned(String site, String rack, String machine) {
        int count = 0;
        for (Address node : this.topologyInfo.getMachineNodes(site, rack, machine)) {
            count += this.stats.getOwned(node);
        }
        return count;
    }

    public int getMachinePrimaryOwned(String site, String rack, String machine) {
        int count = 0;
        for (Address node : this.topologyInfo.getMachineNodes(site, rack, machine)) {
            count += this.stats.getPrimaryOwned(node);
        }
        return count;
    }

    public int getOwned(Address node) {
        return this.stats.getOwned(node);
    }

    public int getPrimaryOwned(Address node) {
        return this.stats.getPrimaryOwned(node);
    }

    public int computeMaxSegments(int numSegments, int numOwners, Address node) {
        return this.topologyInfo.computeMaxSegments(numSegments, numOwners, node);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TopologyAwareOwnershipStatistics{\n");
        for (String site : this.topologyInfo.getAllSites()) {
            sb.append(String.format("  %s: %d/%d\n", site, this.getSitePrimaryOwned(site), this.getSiteOwned(site)));
            for (String rack : this.topologyInfo.getSiteRacks(site)) {
                sb.append(String.format("    %s: %d/%d\n", rack, this.getRackPrimaryOwned(site, rack), this.getRackOwned(site, rack)));
                for (String machine : this.topologyInfo.getRackMachines(site, rack)) {
                    sb.append(String.format("      %s: %d/%d\n", machine, this.getMachinePrimaryOwned(site, rack, machine), this.getMachineOwned(site, rack, machine)));
                    for (Address node : this.topologyInfo.getMachineNodes(site, rack, machine)) {
                        sb.append(String.format("        %s: %d/%d (%d)\n", node, this.stats.getPrimaryOwned(node), this.stats.getOwned(node), this.topologyInfo.computeMaxSegments(this.ch.getNumSegments(), this.ch.getNumOwners(), node)));
                    }
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

