/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionManagerImpl;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="eviction.EvictionManagerTest")
public class EvictionManagerTest
extends AbstractInfinispanTest {
    private ConfigurationBuilder getCfg() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.eviction().strategy(EvictionStrategy.LRU).maxEntries(123);
        return builder;
    }

    public void testNoEvictionThread() {
        EvictionManagerImpl em = new EvictionManagerImpl();
        Configuration cfg = this.getCfg().expiration().wakeUpInterval(0L).build();
        ScheduledExecutorService mockService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        em.initialize(mockService, "", cfg, null, null, null);
        em.start();
        assert (em.evictionTask == null) : "Eviction task is not null!  Should not have scheduled anything!";
    }

    public void testWakeupInterval() {
        EvictionManagerImpl em = new EvictionManagerImpl();
        Configuration cfg = this.getCfg().expiration().wakeUpInterval(789L).build();
        ScheduledExecutorService mockService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        em.initialize(mockService, "", cfg, null, null, null);
        ScheduledFuture mockFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockService.scheduleWithFixedDelay((Runnable)Matchers.isA(EvictionManagerImpl.ScheduledTask.class), Matchers.eq((long)789L), Matchers.eq((long)789L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)mockFuture);
        em.start();
        assert (em.evictionTask == mockFuture);
        ((ScheduledExecutorService)Mockito.verify((Object)mockService)).scheduleWithFixedDelay((Runnable)Matchers.any(Runnable.class), Matchers.anyLong(), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)));
    }
}

