/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.infinispan.Cache;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.data.Key;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="invalidation.AsyncAPISyncInvalTest")
public class AsyncAPISyncInvalTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = AsyncAPISyncInvalTest.getDefaultClusteredConfig(this.sync() ? Configuration.CacheMode.INVALIDATION_SYNC : Configuration.CacheMode.INVALIDATION_ASYNC, false);
        this.createClusteredCaches(2, this.getClass().getSimpleName(), c);
    }

    protected boolean sync() {
        return true;
    }

    protected void asyncWait(Class<? extends WriteCommand> ... cmds) {
    }

    protected void resetListeners() {
    }

    protected void assertInvalidated(final Key k, final String value) {
        final String cacheName = this.getClass().getSimpleName();
        if (this.sync()) {
            Cache c1 = this.cache(0, cacheName);
            Cache c2 = this.cache(1, cacheName);
            assert (Util.safeEquals((Object)c1.get((Object)k), (Object)value));
            assert (!c2.containsKey((Object)k));
        } else {
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    Object v0 = AsyncAPISyncInvalTest.this.cache(0, cacheName).get((Object)k);
                    return Util.safeEquals((Object)v0, (Object)value) && !AsyncAPISyncInvalTest.this.cache(1, cacheName).containsKey((Object)k);
                }
            });
        }
    }

    private void initC2(Key k) {
        Cache c1 = this.cache(0, this.getClass().getSimpleName());
        Cache c2 = this.cache(1, this.getClass().getSimpleName());
        c2.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)k, (Object)"v");
    }

    public void testAsyncMethods() throws ExecutionException, InterruptedException {
        Cache c1 = this.cache(0, this.getClass().getSimpleName());
        Cache c2 = this.cache(1, this.getClass().getSimpleName());
        String v = "v";
        String v2 = "v2";
        String v3 = "v3";
        String v4 = "v4";
        String v5 = "v5";
        String v6 = "v6";
        String v_null = "v_nonexistent";
        Key key = new Key("k", true);
        this.initC2(key);
        assert (!c1.containsKey((Object)key));
        assert (v.equals(c2.get((Object)key)));
        this.log.trace((Object)"Here it is");
        NotifyingFuture f = c1.putAsync((Object)key, (Object)v);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.assertInvalidated(key, v);
        this.initC2(key);
        f = c1.putAsync((Object)key, (Object)v2);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v));
        assert (f.isDone());
        this.assertInvalidated(key, v2);
        this.initC2(key);
        NotifyingFuture f2 = c1.putAllAsync(Collections.singletonMap(key, v3));
        assert (f2 != null);
        assert (!f2.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (f2.isDone());
        this.assertInvalidated(key, v3);
        this.initC2(key);
        f = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f != null);
        assert (c2.get((Object)key).equals(v));
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v3));
        assert (f.isDone());
        this.initC2(key);
        f = c1.removeAsync((Object)key);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v3));
        assert (f.isDone());
        this.assertInvalidated(key, null);
        this.initC2(key);
        f = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.assertInvalidated(key, v4);
        this.initC2(key);
        NotifyingFuture f3 = c1.removeAsync((Object)key, (Object)v_null);
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        assert (c2.get((Object)key).equals(v));
        f3 = c1.removeAsync((Object)key, (Object)v4);
        assert (f3 != null);
        assert (!f3.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        this.assertInvalidated(key, null);
        this.initC2(key);
        f = c1.replaceAsync((Object)key, (Object)v5);
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        this.resetListeners();
        c1.put((Object)key, (Object)v);
        this.asyncWait(new Class[0]);
        this.initC2(key);
        f = c1.replaceAsync((Object)key, (Object)v5);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v));
        assert (f.isDone());
        this.assertInvalidated(key, v5);
        this.initC2(key);
        f3 = c1.replaceAsync((Object)key, (Object)v_null, (Object)v6);
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        assert (c2.get((Object)key).equals(v));
        assert (c1.get((Object)key).equals(v5));
        f3 = c1.replaceAsync((Object)key, (Object)v5, (Object)v6);
        assert (f3 != null);
        assert (!f3.isDone());
        assert (c2.get((Object)key).equals(v));
        key.allowSerialization();
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        this.assertInvalidated(key, v6);
    }
}

