/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheClearTest")
public class CacheClearTest
extends SingleCacheManagerTest {
    public static final String JMX_DOMAIN = CacheClearTest.class.getSimpleName();
    private MBeanServer server;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.globalJmxStatistics().jmxDomain(JMX_DOMAIN).mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup()).enable();
        ConfigurationBuilder dcc = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        dcc.transaction().autoCommit(false);
        dcc.jmxStatistics().enable();
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        return new DefaultCacheManager(gcb.build(), dcc.build());
    }

    public void testClear() throws Exception {
        ObjectName defaultOn = TestingUtil.getCacheObjectName(JMX_DOMAIN);
        this.tm().begin();
        this.cache().put((Object)"k", (Object)"v");
        this.tm().commit();
        AssertJUnit.assertFalse((boolean)this.cache().isEmpty());
        this.server.invoke(defaultOn, "clear", new Object[0], new String[0]);
        AssertJUnit.assertTrue((boolean)this.cache().isEmpty());
    }
}

