/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jndi;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jboss.util.naming.NonSerializableFactory;
import org.jnp.server.Main;
import org.jnp.server.SingletonNamingServer;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jndi.BindingTest")
public class BindingTest
extends SingleCacheManagerTest {
    private Main namingMain;
    private SingletonNamingServer namingServer;
    private Properties props;

    @BeforeClass
    public void startJndiServer() throws Exception {
        this.namingServer = new SingletonNamingServer();
        this.namingMain = new Main();
        this.namingMain.setInstallGlobalService(true);
        this.namingMain.setPort(-1);
        this.namingMain.start();
        this.props = new Properties();
        this.props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        this.props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
    }

    @AfterClass(alwaysRun=true)
    public void stopJndiServer() throws Exception {
        this.namingServer.destroy();
        this.namingMain.stop();
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        Configuration configuration = new Configuration();
        this.cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration);
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBindCacheManagerToJndi() throws Exception {
        InitialContext ctx = new InitialContext(this.props);
        String jndiName = "java:CacheManager";
        this.bind(jndiName, this.cacheManager, CacheContainer.class, ctx);
        try {
            InitialContext ctx2 = new InitialContext(this.props);
            try {
                EmbeddedCacheManager cacheManager2 = (EmbeddedCacheManager)ctx2.lookup(jndiName);
                assert (this.cacheManager.getStatus() == cacheManager2.getStatus());
            }
            finally {
                ctx2.close();
            }
        }
        finally {
            this.unbind(jndiName, ctx);
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBindCacheToJndi(Method method) throws Exception {
        InitialContext ctx = new InitialContext(this.props);
        String jndiName = "java:Cache";
        Cache cache = this.cacheManager.getCache(method.getName());
        this.bind(jndiName, cache, Cache.class, ctx);
        try {
            InitialContext ctx2 = new InitialContext(this.props);
            try {
                Cache cache2 = (Cache)ctx2.lookup(jndiName);
                assert (cache.getName() == cache2.getName());
            }
            finally {
                ctx2.close();
            }
        }
        finally {
            this.unbind(jndiName, ctx);
            ctx.close();
        }
    }

    private void bind(String jndiName, Object who, Class<?> classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    private void unbind(String jndiName, Context ctx) throws Exception {
        NonSerializableFactory.unbind((String)jndiName);
        ctx.unbind(jndiName);
    }
}

