/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.io.File;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.LocalModePassivationTest")
@CleanupAfterMethod
public class LocalModePassivationTest
extends SingleCacheManagerTest {
    private File cacheStoreDir;
    private final boolean passivationEnabled;

    protected LocalModePassivationTest() {
        this.passivationEnabled = true;
    }

    protected LocalModePassivationTest(boolean passivationEnabled) {
        this.passivationEnabled = passivationEnabled;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheStoreDir = new File(TestingUtil.tmpDirectory(this));
        TestingUtil.recursiveFileRemove(this.cacheStoreDir);
        ConfigurationBuilder builder = LocalModePassivationTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, true, true);
        ((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).eviction().maxEntries(1000).strategy(EvictionStrategy.LIRS).locking().lockAcquisitionTimeout(20000L).concurrencyLevel(5000).useLockStriping(false).writeSkewCheck(false).isolationLevel(IsolationLevel.READ_COMMITTED).dataContainer().storeAsBinary().loaders().passivation(this.passivationEnabled).preload(false).addFileCacheStore().location(this.cacheStoreDir.getAbsolutePath()).fetchPersistentState(true)).purgerThreads(3)).purgeSynchronously(true)).ignoreModifications(false)).purgeOnStartup(false);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove(this.cacheStoreDir);
    }

    public void testStoreAndLoad() throws Exception {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache().put((Object)i, (Object)i);
        }
        int keysInDataContainer = this.cache().getAdvancedCache().getDataContainer().keySet().size();
        AssertJUnit.assertTrue((keysInDataContainer != 300 ? 1 : 0) != 0);
        CacheLoaderManager cml = (CacheLoaderManager)this.cache().getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        int keysInCacheStore = cml.getCacheLoader().loadAll().size();
        if (this.passivationEnabled) {
            AssertJUnit.assertEquals((int)300, (int)(keysInDataContainer + keysInCacheStore));
        } else {
            AssertJUnit.assertEquals((int)300, (int)keysInCacheStore);
        }
        this.cache().stop();
        this.cache().start();
        cml = (CacheLoaderManager)this.cache().getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        AssertJUnit.assertEquals((int)300, (int)cml.getCacheLoader().loadAll().size());
        for (int i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((Object)i, (Object)this.cache().get((Object)i));
        }
    }
}

