/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.PassivationFunctionalTest")
public class PassivationFunctionalTest
extends AbstractInfinispanTest {
    Cache cache;
    CacheStore store;
    TransactionManager tm;
    Configuration cfg;
    CacheContainer cm;
    long lifespan = 6000000L;

    @BeforeTest
    public void setUp() {
        this.cfg = TestCacheManagerFactory.getDefaultConfiguration(true);
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        clmc.setPassivation(Boolean.valueOf(true));
        clmc.addCacheLoaderConfig((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg());
        this.cfg.setCacheLoaderManagerConfig(clmc);
        this.cm = TestCacheManagerFactory.createCacheManager(this.cfg);
        this.cache = this.cm.getCache();
        this.store = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterTest(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws CacheLoaderException {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.store != null) {
            this.store.clear();
        }
    }

    private void assertInCacheNotInStore(Object key, Object value) throws CacheLoaderException {
        this.assertInCacheNotInStore(key, value, -1L);
    }

    private void assertInCacheNotInStore(Object key, Object value, long lifespanMillis) throws CacheLoaderException {
        InternalCacheEntry se = this.cache.getAdvancedCache().getDataContainer().get(key);
        this.testStoredEntry(se, value, lifespanMillis, "Cache", key);
        assert (!this.store.containsKey(key)) : "Key " + key + " should not be in store!";
    }

    private void assertInStoreNotInCache(Object key, Object value) throws CacheLoaderException {
        this.assertInStoreNotInCache(key, value, -1L);
    }

    private void assertInStoreNotInCache(Object key, Object value, long lifespanMillis) throws CacheLoaderException {
        InternalCacheEntry se = this.store.load(key);
        this.testStoredEntry(se, value, lifespanMillis, "Store", key);
        assert (!this.cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Key " + key + " should not be in cache!";
    }

    private void testStoredEntry(InternalCacheEntry entry, Object expectedValue, long expectedLifespan, String src, Object key) {
        assert (entry != null) : src + " entry for key " + key + " should NOT be null";
        assert (entry.getValue().equals(expectedValue)) : src + " should contain value " + expectedValue + " under key " + entry.getKey() + " but was " + entry.getValue() + ". Entry is " + entry;
        assert (entry.getLifespan() == expectedLifespan) : src + " expected lifespan for key " + key + " to be " + expectedLifespan + " but was " + entry.getLifespan() + ". Entry is " + entry;
    }

    private void assertNotInCacheAndStore(Object ... keys) throws CacheLoaderException {
        for (Object key : keys) {
            assert (!this.cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Cache should not contain key " + key;
            assert (!this.store.containsKey(key)) : "Store should not contain key " + key;
        }
    }

    public void testPassivate() throws CacheLoaderException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
        assert (this.cache.get((Object)"k1").equals("v1"));
        assert (this.cache.get((Object)"k2").equals("v2"));
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
    }

    public void testRemoveAndReplace() throws CacheLoaderException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
        assert (this.cache.remove((Object)"k1").equals("v1"));
        this.assertNotInCacheAndStore("k1");
        assert (this.cache.put((Object)"k2", (Object)"v2-NEW").equals("v2"));
        this.assertInCacheNotInStore("k2", "v2-NEW");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-NEW");
        assert (this.cache.replace((Object)"k2", (Object)"v2-REPLACED").equals("v2-NEW"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-REPLACED");
        assert (!this.cache.replace((Object)"k2", (Object)"some-rubbish", (Object)"v2-SHOULDNT-STORE"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-REPLACED");
        assert (this.cache.replace((Object)"k2", (Object)"v2-REPLACED", (Object)"v2-REPLACED-AGAIN"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED-AGAIN");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-REPLACED-AGAIN");
        assert (this.cache.putIfAbsent((Object)"k2", (Object)"should-not-appear").equals("v2-REPLACED-AGAIN"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED-AGAIN");
        assert (this.cache.putIfAbsent((Object)"k1", (Object)"v1-if-absent") == null);
        this.assertInCacheNotInStore("k1", "v1-if-absent");
    }

    public void testTransactions() throws Exception {
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        Transaction t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.commit();
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.tm.begin();
        this.cache.clear();
        t = this.tm.suspend();
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.tm.resume(t);
        this.tm.commit();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.rollback();
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
    }

    public void testPutMap() throws CacheLoaderException {
        this.assertNotInCacheAndStore("k1", "k2", "k3");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.cache.evict((Object)"k2");
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k1", "v1-NEW");
        m.put("k2", "v2-NEW");
        m.put("k3", "v3-NEW");
        this.cache.putAll(m);
        this.assertInCacheNotInStore("k1", "v1-NEW");
        this.assertInCacheNotInStore("k2", "v2-NEW");
        this.assertInCacheNotInStore("k3", "v3-NEW");
    }
}

