/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.lock.FailInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="lock.StaleEagerLocksOnPrepareFailureTest", groups={"functional"})
@CleanupAfterMethod
public class StaleEagerLocksOnPrepareFailureTest
extends MultipleCacheManagersTest {
    Cache<MagicKey, String> c1;
    Cache<MagicKey, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.DIST_SYNC);
        cfg.setUseEagerLocking(true);
        cfg.setEagerLockSingleNode(true);
        cfg.setLockAcquisitionTimeout(100L);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        this.c1 = cm1.getCache();
        this.c2 = cm2.getCache();
        this.waitForClusterToForm();
    }

    public void testNoModsCommit() throws Exception {
        this.doTest(false);
    }

    public void testModsCommit() throws Exception {
        this.doTest(true);
    }

    private void doTest(boolean mods) throws Exception {
        FailInterceptor interceptor = new FailInterceptor();
        interceptor.failFor(PrepareCommand.class);
        InterceptorChain ic = TestingUtil.extractComponent(this.c2, InterceptorChain.class);
        ic.addInterceptorBefore((CommandInterceptor)interceptor, TxDistributionInterceptor.class);
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.tm(this.c1).begin();
        if (mods) {
            this.c1.put((Object)k1, (Object)"v1");
            this.c1.put((Object)k2, (Object)"v2");
            this.assertKeyLockedCorrectly(k1);
            this.assertKeyLockedCorrectly(k2);
        } else {
            this.c1.getAdvancedCache().lock((Object[])new MagicKey[]{k1});
            this.c1.getAdvancedCache().lock((Object[])new MagicKey[]{k2});
            Assert.assertNull((Object)this.c1.get((Object)k1));
            Assert.assertNull((Object)this.c1.get((Object)k2));
            this.assertKeyLockedCorrectly(k1);
            this.assertKeyLockedCorrectly(k2);
        }
        try {
            this.tm(this.c1).commit();
            assert (false) : "Commit should have failed";
        }
        catch (Exception e) {
            // empty catch block
        }
        this.assertNotLocked(this.c1, (Object)k1);
        this.assertNotLocked(this.c2, (Object)k1);
        this.assertNotLocked(this.c1, (Object)k2);
        this.assertNotLocked(this.c2, (Object)k2);
    }
}

