/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.OriginatorBecomesOwnerLockTest")
@CleanupAfterMethod
public class OriginatorBecomesOwnerLockTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder configurationBuilder;
    private static final int ORIGINATOR_INDEX = 0;
    private static final int OTHER_INDEX = 1;
    private static final int KILLED_INDEX = 2;
    private Cache<Object, String> originatorCache;
    private Cache<Object, String> killedCache;
    private Cache<Object, String> otherCache;
    private boolean waitForStateTransfer = true;
    private boolean stopCacheOnly = true;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configurationBuilder = OriginatorBecomesOwnerLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.configurationBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.configurationBuilder.clustering().sync().replTimeout(30000L, TimeUnit.MILLISECONDS);
        this.configurationBuilder.clustering().hash().l1().disable().onRehash(false).locking().lockAcquisitionTimeout(1000L);
        this.configurationBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        this.createCluster(this.configurationBuilder, 3);
        this.waitForClusterToForm();
        this.originatorCache = this.cache(0);
        this.killedCache = this.cache(2);
        this.otherCache = this.cache(1);
    }

    public void testOriginatorBecomesPrimaryOwnerDuringPrepare() throws Exception {
        MagicKey key = new MagicKey("primary", this.cache(2), this.cache(0));
        this.testLockMigrationDuringPrepare(key);
    }

    public void testOriginatorBecomesBackupOwnerDuringPrepare() throws Exception {
        MagicKey key = new MagicKey("backup", this.cache(2), this.cache(1));
        this.testLockMigrationDuringPrepare(key);
    }

    private void testLockMigrationDuringPrepare(final Object key) throws Exception {
        ControlledRpcManager controlledRpcManager = this.installControlledRpcManager();
        controlledRpcManager.blockBefore(PrepareCommand.class);
        final DummyTransactionManager tm = this.dummyTm(0);
        Future<DummyTransaction> f = this.fork(new Callable<DummyTransaction>(){

            @Override
            public DummyTransaction call() throws Exception {
                tm.begin();
                OriginatorBecomesOwnerLockTest.this.originatorCache.put(key, (Object)"value");
                DummyTransaction tx = tm.getTransaction();
                boolean success = tx.runPrepare();
                Assert.assertTrue((boolean)success);
                tm.suspend();
                return tx;
            }
        });
        Thread.sleep(2000L);
        this.log.trace((Object)"Lock transfer happens here");
        this.killCache();
        this.log.trace((Object)"Allow the prepare RPC to proceed");
        controlledRpcManager.stopBlocking();
        DummyTransaction tx = f.get();
        this.log.tracef("Prepare finished", new Object[0]);
        this.checkNewTransactionFails(key);
        this.log.trace((Object)"About to commit existing transactions.");
        tm.resume((Transaction)tx);
        tx.runCommitTx();
        this.checkValue(key, "value");
    }

    public void testOriginatorBecomesPrimaryOwnerAfterPrepare() throws Exception {
        MagicKey key = new MagicKey("primary", this.cache(2), this.cache(0));
        this.testLockMigrationAfterPrepare(key);
    }

    public void testOriginatorBecomesBackupOwnerAfterPrepare() throws Exception {
        MagicKey key = new MagicKey("backup", this.cache(2), this.cache(1));
        this.testLockMigrationAfterPrepare(key);
    }

    private void testLockMigrationAfterPrepare(Object key) throws Exception {
        DummyTransactionManager tm = this.dummyTm(0);
        tm.begin();
        this.originatorCache.put(key, (Object)"value");
        DummyTransaction tx = tm.getTransaction();
        boolean prepareSuccess = tx.runPrepare();
        assert (prepareSuccess);
        tm.suspend();
        this.log.trace((Object)"Lock transfer happens here");
        this.killCache();
        this.checkNewTransactionFails(key);
        this.log.trace((Object)"About to commit existing transaction.");
        tm.resume((Transaction)tx);
        tx.runCommitTx();
        this.checkValue(key, "value");
    }

    public void testOriginatorBecomesPrimaryOwnerDuringCommit() throws Exception {
        MagicKey key = new MagicKey("primary", this.cache(2), this.cache(0));
        this.testLockMigrationDuringCommit(key);
    }

    public void testOriginatorBecomesBackupOwnerDuringCommit() throws Exception {
        MagicKey key = new MagicKey("backup", this.cache(2), this.cache(1));
        this.testLockMigrationDuringCommit(key);
    }

    private void testLockMigrationDuringCommit(final Object key) throws Exception {
        ControlledRpcManager controlledRpcManager = this.installControlledRpcManager();
        controlledRpcManager.blockBefore(CommitCommand.class);
        final DummyTransactionManager tm = this.dummyTm(0);
        Future<DummyTransaction> f = this.fork(new Callable<DummyTransaction>(){

            @Override
            public DummyTransaction call() throws Exception {
                tm.begin();
                OriginatorBecomesOwnerLockTest.this.originatorCache.put(key, (Object)"value");
                DummyTransaction tx = tm.getTransaction();
                boolean success = tx.runPrepare();
                assert (success);
                OriginatorBecomesOwnerLockTest.this.log.trace((Object)"About to commit transaction.");
                tx.runCommitTx();
                return null;
            }
        });
        Thread.sleep(2000L);
        this.log.trace((Object)"Lock transfer happens here");
        this.killCache();
        this.log.trace((Object)"Allow the commit RPC to proceed");
        controlledRpcManager.stopBlocking();
        f.get();
        this.log.tracef("Commit finished", new Object[0]);
        this.checkValue(key, "value");
        this.assertNoLocksOrTxs(key, this.originatorCache);
        this.assertNoLocksOrTxs(key, this.otherCache);
    }

    private void assertNoLocksOrTxs(Object key, Cache<Object, String> cache) {
        this.assertNotLocked(this.originatorCache, key);
        final TransactionTable transactionTable = TestingUtil.extractComponent(cache, TransactionTable.class);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return transactionTable.getLocalTxCount() == 0 && transactionTable.getRemoteTxCount() == 0;
            }
        });
    }

    private ControlledRpcManager installControlledRpcManager() {
        ControlledRpcManager controlledRpcManager = new ControlledRpcManager(this.originatorCache.getAdvancedCache().getRpcManager());
        TestingUtil.replaceComponent(this.originatorCache, RpcManager.class, controlledRpcManager, true);
        return controlledRpcManager;
    }

    private void killCache() {
        if (this.stopCacheOnly) {
            this.killedCache.stop();
        } else {
            this.manager(2).stop();
        }
        if (this.waitForStateTransfer) {
            TestingUtil.waitForRehashToComplete(this.originatorCache, this.otherCache);
        }
    }

    private void checkValue(Object key, String value) {
        if (!this.waitForStateTransfer) {
            TestingUtil.waitForRehashToComplete(this.originatorCache, this.otherCache);
        }
        this.log.tracef("Checking key: %s", key);
        InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(key);
        InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(key);
        Assert.assertEquals((Object)d0.getValue(), (Object)value);
        Assert.assertEquals((Object)d1.getValue(), (Object)value);
    }

    private void checkNewTransactionFails(Object key) throws NotSupportedException, SystemException, HeuristicMixedException, HeuristicRollbackException {
        DummyTransactionManager otherTM = this.dummyTm(1);
        otherTM.begin();
        this.otherCache.put(key, (Object)"should fail");
        try {
            otherTM.commit();
            Assert.fail((String)"RollbackException should have been thrown here.");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    private DummyTransactionManager dummyTm(int cacheIndex) {
        return (DummyTransactionManager)this.tm(cacheIndex);
    }
}

