/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.pessimistic;

import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractInitiatorCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.pessimistic.InitiatorCrashPessimisticTest")
@CleanupAfterMethod
public class InitiatorCrashPessimisticTest
extends AbstractInitiatorCrashTest {
    public InitiatorCrashPessimisticTest() {
        super(Configuration.CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, false);
    }

    public void testInitiatorNodeCrashesBeforePrepare2() throws Exception {
        Object k0 = this.getKeyForCache(0);
        Object k1 = this.getKeyForCache(1);
        Object k2 = this.getKeyForCache(2);
        this.tm(1).begin();
        this.cache(1).put(k0, (Object)"v0");
        this.cache(1).put(k1, (Object)"v1");
        this.cache(1).put(k2, (Object)"v2");
        this.assertLocked(this.cache(0), k0);
        this.assertNotLocked(this.cache(1), k0);
        this.assertNotLocked(this.cache(2), k0);
        this.assertNotLocked(this.cache(0), k1);
        this.assertLocked(this.cache(1), k1);
        this.assertNotLocked(this.cache(2), k1);
        this.assertNotLocked(this.cache(0), k2);
        this.assertNotLocked(this.cache(1), k2);
        this.assertLocked(this.cache(2), k2);
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 1, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.killMember(1);
        assert (this.caches().size() == 2);
        this.assertNotLocked(k0);
        this.assertNotLocked(k1);
        this.assertNotLocked(k2);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return InitiatorCrashPessimisticTest.this.checkTxCount(0, 0, 0) && InitiatorCrashPessimisticTest.this.checkTxCount(1, 0, 0);
            }
        });
    }
}

