/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.ConcurrentMarshallerTest")
public class ConcurrentMarshallerTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ConcurrentMarshallerTest.getDefaultClusteredCacheConfig(CacheMode.REPL_ASYNC, false);
        builder.clustering().async().useReplQueue(true);
        this.createClusteredCaches(2, "concurrentMarshaller", builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test000() throws Exception {
        Cache cache1 = this.cache(0, "concurrentMarshaller");
        int nbWriters = 10;
        CyclicBarrier barrier = new CyclicBarrier(nbWriters + 1);
        ArrayList<Future> futures = new ArrayList<Future>(nbWriters);
        ExecutorService exec = Executors.newCachedThreadPool(new ThreadFactory(){
            volatile int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                int ii = this.i++;
                return new Thread(r, "ConcurrentMarshallerTester-" + ii);
            }
        });
        try {
            for (int i = 0; i < nbWriters; ++i) {
                this.log.debug((Object)"Schedule execution");
                Future future = exec.submit(new CacheUpdater(barrier, cache1));
                futures.add(future);
            }
            barrier.await();
            barrier.await();
            this.log.debug((Object)"Threads finished, shutdown executor and check for exceptions");
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            exec.shutdownNow();
        }
    }

    static class CacheUpdater
    implements Callable<Void> {
        static final Log log = LogFactory.getLog(CacheUpdater.class);
        CyclicBarrier barrier;
        Cache cache;

        CacheUpdater(CyclicBarrier barrier, Cache cache) {
            this.barrier = barrier;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            log.debug((Object)"Wait for all executions paths to be ready");
            this.barrier.await();
            try {
                for (int i = 0; i < 10; ++i) {
                    String decimal = Integer.toString(i);
                    ByteArrayKey key = new ByteArrayKey(("key-" + Thread.currentThread().getName() + decimal).getBytes());
                    ByteArrayKey value = new ByteArrayKey(("value-" + Thread.currentThread().getName() + decimal).getBytes());
                    this.cache.put((Object)key, (Object)value);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                log.debug((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
        }
    }
}

