/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.CustomClass;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.MarshalledValuesFineGrainedTest")
public class MarshalledValuesFineGrainedTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager ecm;
    final CustomClass key = new CustomClass("key");
    final CustomClass value = new CustomClass("value");

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        TestingUtil.killCacheManagers(this.ecm);
        this.ecm = null;
    }

    public void testStoreAsBinaryOnBoth() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeKeysAsBinary(Boolean.valueOf(true)).storeValuesAsBinary(Boolean.valueOf(true)).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        this.ecm.getCache().put((Object)this.key, (Object)this.value);
        DataContainer dc = this.ecm.getCache().getAdvancedCache().getDataContainer();
        InternalCacheEntry entry = (InternalCacheEntry)dc.iterator().next();
        Object key = entry.getKey();
        Object value = entry.getValue();
        assert (key instanceof MarshalledValue);
        assert (((MarshalledValue)key).get().equals(this.key));
        assert (value instanceof MarshalledValue);
        assert (((MarshalledValue)value).get().equals(this.value));
    }

    public void testStoreAsBinaryOnKeys() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeValuesAsBinary(Boolean.valueOf(false)).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        this.ecm.getCache().put((Object)this.key, (Object)this.value);
        DataContainer dc = this.ecm.getCache().getAdvancedCache().getDataContainer();
        InternalCacheEntry entry = (InternalCacheEntry)dc.iterator().next();
        Object key = entry.getKey();
        Object value = entry.getValue();
        assert (key instanceof MarshalledValue);
        assert (((MarshalledValue)key).get().equals(this.key));
        assert (this.value.equals(value));
    }

    public void testStoreAsBinaryOnValues() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeKeysAsBinary(Boolean.valueOf(false)).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        this.ecm.getCache().put((Object)this.key, (Object)this.value);
        DataContainer dc = this.ecm.getCache().getAdvancedCache().getDataContainer();
        InternalCacheEntry entry = (InternalCacheEntry)dc.iterator().next();
        Object key = entry.getKey();
        Object value = entry.getValue();
        assert (this.key.equals(key));
        assert (value instanceof MarshalledValue);
        assert (((MarshalledValue)value).get().equals(this.value));
    }

    public void testStoreAsBinaryOnNeither() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeKeysAsBinary(Boolean.valueOf(false)).storeValuesAsBinary(Boolean.valueOf(false)).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        this.ecm.getCache().put((Object)this.key, (Object)this.value);
        DataContainer dc = this.ecm.getCache().getAdvancedCache().getDataContainer();
        assert (this.value.equals(dc.get((Object)this.key).getValue()));
    }
}

