/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHashFactory;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.AbstractDelegatingMarshaller;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.NotSerializableException;
import org.infinispan.marshall.PojoWithJBossExternalize;
import org.infinispan.marshall.PojoWithSerializeWith;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.JBossMarshallingTest;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.FastCopyHashMap;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.TraceInformation;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.UUID;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.VersionAwareMarshallerTest")
public class VersionAwareMarshallerTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(VersionAwareMarshallerTest.class);
    private AbstractDelegatingMarshaller marshaller;
    private EmbeddedCacheManager cm;
    private final TransactionFactory gtf = new TransactionFactory();

    public VersionAwareMarshallerTest() {
        this.gtf.init(false, false, true, false);
    }

    @BeforeTest
    public void setUp() {
        this.cm = TestCacheManagerFactory.createClusteredCacheManager();
        this.cm.getDefaultConfiguration().fluent().clustering().mode(Configuration.CacheMode.DIST_SYNC);
        this.marshaller = TestingUtil.extractCacheMarshaller(this.cm.getCache());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.cm.stop();
    }

    public void testJGroupsAddressMarshalling() throws Exception {
        JGroupsAddress address = new JGroupsAddress((Address)new IpAddress(12345));
        this.marshallAndAssertEquality(address);
    }

    public void testGlobalTransactionMarshalling() throws Exception {
        JGroupsAddress jGroupsAddress = new JGroupsAddress((Address)new IpAddress(12345));
        GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)jGroupsAddress, false);
        this.marshallAndAssertEquality(gtx);
    }

    public void testListMarshalling() throws Exception {
        ArrayList<GlobalTransaction> l1 = new ArrayList<GlobalTransaction>();
        LinkedList<GlobalTransaction> l2 = new LinkedList<GlobalTransaction>();
        for (int i = 0; i < 10; ++i) {
            JGroupsAddress jGroupsAddress = new JGroupsAddress((Address)new IpAddress(1000 * i));
            GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)jGroupsAddress, false);
            l1.add(gtx);
            l2.add(gtx);
        }
        this.marshallAndAssertEquality(l1);
        this.marshallAndAssertEquality(l2);
    }

    public void testMapMarshalling() throws Exception {
        HashMap<Integer, GlobalTransaction> m1 = new HashMap<Integer, GlobalTransaction>();
        TreeMap<Integer, GlobalTransaction> m2 = new TreeMap<Integer, GlobalTransaction>();
        HashMap m3 = new HashMap();
        FastCopyHashMap m4 = new FastCopyHashMap();
        for (int i = 0; i < 10; ++i) {
            JGroupsAddress jGroupsAddress = new JGroupsAddress((Address)new IpAddress(1000 * i));
            GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)jGroupsAddress, false);
            m1.put(1000 * i, gtx);
            m2.put(1000 * i, gtx);
            m4.put(1000 * i, gtx);
        }
        Map m5 = Immutables.immutableMapWrap(m3);
        this.marshallAndAssertEquality(m1);
        this.marshallAndAssertEquality(m2);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)m4);
        Map m4Read = (Map)this.marshaller.objectFromByteBuffer(bytes);
        for (Map.Entry entry : m4.entrySet()) {
            assert (((GlobalTransaction)m4Read.get(entry.getKey())).equals(entry.getValue())) : "Writen[" + entry.getValue() + "] and read[" + m4Read.get(entry.getKey()) + "] objects should be the same";
        }
        this.marshallAndAssertEquality(m5);
    }

    public void testSetMarshalling() throws Exception {
        HashSet<Integer> s1 = new HashSet<Integer>();
        TreeSet<Integer> s2 = new TreeSet<Integer>();
        for (int i = 0; i < 10; ++i) {
            Integer integ = 1000 * i;
            s1.add(integ);
            s2.add(integ);
        }
        this.marshallAndAssertEquality(s1);
        this.marshallAndAssertEquality(s2);
    }

    public void testTreeSetWithComparator() throws Exception {
        TreeSet<Human> treeSet = new TreeSet<Human>(new HumanComparator());
        for (int i = 0; i < 10; ++i) {
            treeSet.add(new Human().age(i));
        }
        this.marshallAndAssertEquality(treeSet);
    }

    public void testMarshalledValueMarshalling() throws Exception {
        Person p = new Person();
        p.setName("Bob Dylan");
        MarshalledValue mv = new MarshalledValue((Object)p, true, (StreamingMarshaller)this.marshaller);
        this.marshallAndAssertEquality(mv);
    }

    public void testMarshalledValueGetMarshalling() throws Exception {
        Pojo ext = new Pojo();
        MarshalledValue mv = new MarshalledValue((Object)ext, true, (StreamingMarshaller)this.marshaller);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)mv);
        MarshalledValue rmv = (MarshalledValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rmv.equals((Object)mv)) : "Writen[" + mv + "] and read[" + rmv + "] objects should be the same";
        assert (rmv.get() instanceof Pojo);
    }

    public void testSingletonListMarshalling() throws Exception {
        GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)new JGroupsAddress((Address)new IpAddress(12345)), false);
        List<GlobalTransaction> l = Collections.singletonList(gtx);
        this.marshallAndAssertEquality(l);
    }

    public void testImmutableResponseMarshalling() throws Exception {
        this.marshallAndAssertEquality(UnsuccessfulResponse.INSTANCE);
    }

    public void testReplicableCommandsMarshalling() throws Exception {
        String cacheName = "___defaultcache";
        ClusteredGetCommand c2 = new ClusteredGetCommand("key", cacheName, Collections.emptySet());
        this.marshallAndAssertEquality(c2);
        GetKeyValueCommand c4 = new GetKeyValueCommand((Object)"key", Collections.emptySet());
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)c4);
        GetKeyValueCommand rc4 = (GetKeyValueCommand)this.marshaller.objectFromByteBuffer(bytes);
        assert (rc4.getCommandId() == c4.getCommandId()) : "Writen[" + c4.getCommandId() + "] and read[" + rc4.getCommandId() + "] objects should be the same";
        assert (Arrays.equals(rc4.getParameters(), c4.getParameters())) : "Writen[" + c4.getParameters() + "] and read[" + rc4.getParameters() + "] objects should be the same";
        PutKeyValueCommand c5 = new PutKeyValueCommand((Object)"k", (Object)"v", false, null, 0L, 0L, Collections.emptySet());
        this.marshallAndAssertEquality(c5);
        RemoveCommand c6 = new RemoveCommand((Object)"key", null, null, Collections.emptySet());
        this.marshallAndAssertEquality(c6);
        InvalidateCommand c7 = new InvalidateCommand(null, null, new Object[]{"key1", "key2"});
        bytes = this.marshaller.objectToByteBuffer((Object)c7);
        InvalidateCommand rc7 = (InvalidateCommand)this.marshaller.objectFromByteBuffer(bytes);
        assert (rc7.getCommandId() == c7.getCommandId()) : "Writen[" + c7.getCommandId() + "] and read[" + rc7.getCommandId() + "] objects should be the same";
        assert (Arrays.equals(rc7.getParameters(), c7.getParameters())) : "Writen[" + c7.getParameters() + "] and read[" + rc7.getParameters() + "] objects should be the same";
        InvalidateL1Command c71 = new InvalidateL1Command(false, null, null, null, null, Collections.emptySet(), new Object[]{"key1", "key2"});
        bytes = this.marshaller.objectToByteBuffer((Object)c71);
        InvalidateCommand rc71 = (InvalidateCommand)this.marshaller.objectFromByteBuffer(bytes);
        assert (rc71.getCommandId() == c71.getCommandId()) : "Writen[" + c71.getCommandId() + "] and read[" + rc71.getCommandId() + "] objects should be the same";
        assert (Arrays.equals(rc71.getParameters(), c71.getParameters())) : "Writen[" + c71.getParameters() + "] and read[" + rc71.getParameters() + "] objects should be the same";
        ReplaceCommand c8 = new ReplaceCommand((Object)"key", (Object)"oldvalue", (Object)"newvalue", null, 0L, 0L, Collections.EMPTY_SET);
        this.marshallAndAssertEquality(c8);
        ClearCommand c9 = new ClearCommand();
        bytes = this.marshaller.objectToByteBuffer((Object)c9);
        ClearCommand rc9 = (ClearCommand)this.marshaller.objectFromByteBuffer(bytes);
        assert (rc9.getCommandId() == c9.getCommandId()) : "Writen[" + c9.getCommandId() + "] and read[" + rc9.getCommandId() + "] objects should be the same";
        assert (Arrays.equals(rc9.getParameters(), c9.getParameters())) : "Writen[" + c9.getParameters() + "] and read[" + rc9.getParameters() + "] objects should be the same";
        HashMap<Integer, GlobalTransaction> m1 = new HashMap<Integer, GlobalTransaction>();
        for (int i = 0; i < 10; ++i) {
            GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)new JGroupsAddress((Address)new IpAddress(1000 * i)), false);
            m1.put(1000 * i, gtx);
        }
        PutMapCommand c10 = new PutMapCommand(m1, null, 0L, 0L, Collections.emptySet());
        this.marshallAndAssertEquality(c10);
        JGroupsAddress local = new JGroupsAddress((Address)new IpAddress(12345));
        GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)local, false);
        PrepareCommand c11 = new PrepareCommand(cacheName, gtx, true, new WriteCommand[]{c5, c6, c8, c10});
        this.marshallAndAssertEquality(c11);
        CommitCommand c12 = new CommitCommand(cacheName, gtx);
        this.marshallAndAssertEquality(c12);
        RollbackCommand c13 = new RollbackCommand(cacheName, gtx);
        this.marshallAndAssertEquality(c13);
        MultipleRpcCommand c99 = new MultipleRpcCommand(Arrays.asList(c2, c5, c6, c8, c10, c12, c13), cacheName);
        this.marshallAndAssertEquality(c99);
    }

    public void testStateTransferControlCommand() throws Exception {
        Cache cache = this.cm.getCache();
        String cacheName = "___defaultcache";
        ImmortalCacheEntry entry1 = (ImmortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), -1L);
        ArrayList<ImmortalCacheEntry> state = new ArrayList<ImmortalCacheEntry>();
        state.add(entry1);
        JGroupsAddress a1 = new JGroupsAddress((Address)UUID.randomUUID());
        JGroupsAddress a2 = new JGroupsAddress((Address)UUID.randomUUID());
        JGroupsAddress a3 = new JGroupsAddress((Address)UUID.randomUUID());
        ArrayList<JGroupsAddress> oldAddresses = new ArrayList<JGroupsAddress>();
        oldAddresses.add(a1);
        oldAddresses.add(a2);
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        DefaultConsistentHash oldCh = chf.create((Hash)new MurmurHash3(), 2, 3, oldAddresses);
        ArrayList<JGroupsAddress> newAddresses = new ArrayList<JGroupsAddress>();
        newAddresses.add(a1);
        newAddresses.add(a2);
        newAddresses.add(a3);
        DefaultConsistentHash newCh = chf.create((Hash)new MurmurHash3(), 2, 3, newAddresses);
        StateRequestCommand c14 = new StateRequestCommand(cacheName, StateRequestCommand.Type.START_STATE_TRANSFER, (org.infinispan.remoting.transport.Address)a1, 99, null);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)c14);
        this.marshaller.objectFromByteBuffer(bytes);
        bytes = this.marshaller.objectToByteBuffer((Object)c14);
        this.marshaller.objectFromByteBuffer(bytes);
        bytes = this.marshaller.objectToByteBuffer((Object)c14);
        this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testMultiRpcCommand() throws Exception {
        String cacheName = "___defaultcache";
        ClusteredGetCommand c2 = new ClusteredGetCommand("key", cacheName, Collections.emptySet());
        PutKeyValueCommand c5 = new PutKeyValueCommand((Object)"k", (Object)"v", false, null, 0L, 0L, Collections.emptySet());
        MultipleRpcCommand c99 = new MultipleRpcCommand(Arrays.asList(c2, c5), cacheName);
        this.marshallAndAssertEquality(c99);
    }

    public void testInternalCacheEntryMarshalling() throws Exception {
        ImmortalCacheEntry entry1 = (ImmortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), -1L);
        this.marshallAndAssertEquality(entry1);
        MortalCacheEntry entry2 = (MortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), -1L);
        this.marshallAndAssertEquality(entry2);
        TransientCacheEntry entry3 = (TransientCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), 4000000L);
        this.marshallAndAssertEquality(entry3);
        TransientMortalCacheEntry entry4 = (TransientMortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), 4000000L);
        this.marshallAndAssertEquality(entry4);
    }

    public void testInternalCacheValueMarshalling() throws Exception {
        ImmortalCacheValue value1 = (ImmortalCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), -1L);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)value1);
        ImmortalCacheValue rvalue1 = (ImmortalCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue1.getValue().equals(value1.getValue())) : "Writen[" + rvalue1.getValue() + "] and read[" + value1.getValue() + "] objects should be the same";
        MortalCacheValue value2 = (MortalCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), -1L);
        bytes = this.marshaller.objectToByteBuffer((Object)value2);
        MortalCacheValue rvalue2 = (MortalCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue2.getValue().equals(value2.getValue())) : "Writen[" + rvalue2.getValue() + "] and read[" + value2.getValue() + "] objects should be the same";
        TransientCacheValue value3 = (TransientCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), 4000000L);
        bytes = this.marshaller.objectToByteBuffer((Object)value3);
        TransientCacheValue rvalue3 = (TransientCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue3.getValue().equals(value3.getValue())) : "Writen[" + rvalue3.getValue() + "] and read[" + value3.getValue() + "] objects should be the same";
        TransientMortalCacheValue value4 = (TransientMortalCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), 4000000L);
        bytes = this.marshaller.objectToByteBuffer((Object)value4);
        TransientMortalCacheValue rvalue4 = (TransientMortalCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue4.getValue().equals(value4.getValue())) : "Writen[" + rvalue4.getValue() + "] and read[" + value4.getValue() + "] objects should be the same";
    }

    public void testBucketMarshalling() throws Exception {
        ImmortalCacheEntry entry1 = (ImmortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), -1L);
        MortalCacheEntry entry2 = (MortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), -1L);
        TransientCacheEntry entry3 = (TransientCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), 4000000L);
        TransientMortalCacheEntry entry4 = (TransientMortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), 4000000L);
        Bucket b = new Bucket();
        b.setBucketId(Integer.valueOf(0));
        b.addEntry((InternalCacheEntry)entry1);
        b.addEntry((InternalCacheEntry)entry2);
        b.addEntry((InternalCacheEntry)entry3);
        b.addEntry((InternalCacheEntry)entry4);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)b);
        Bucket rb = (Bucket)this.marshaller.objectFromByteBuffer(bytes);
        assert (rb.getEntries().equals(b.getEntries())) : "Writen[" + b.getEntries() + "] and read[" + rb.getEntries() + "] objects should be the same";
    }

    public void testLongPutKeyValueCommand() throws Exception {
        PutKeyValueCommand c = new PutKeyValueCommand((Object)"SESSION_173", (Object)"@TSXMHVROYNOFCJVEUJQGBCENNQDEWSCYSOHECJOHEICBEIGJVTIBB@TVNCWLTQCGTEJ@NBJLTMVGXCHXTSVE@BCRYGWPRVLXOJXBRJDVNBVXPRTRLBMHPOUYQKDEPDSADUAWPFSIOCINPSSFGABDUXRMTMMJMRTGBGBOAMGVMTKUDUAJGCAHCYW@LAXMDSFYOSXJXLUAJGQKPTHUKDOXRWKEFIVRTH@VIMQBGYPKWMS@HPOESTPIJE@OTOTWUWIOBLYKQQPTNGWVLRRCWHNIMWDQNOO@JHHEVYVQEODMWKFKKKSWURVDLXPTFQYIHLIM@GSBFWMDQGDQIJONNEVHGQTLDBRBML@BEWGHOQHHEBRFUQSLB@@CILXEAVQQBTXSITMBXHMHORHLTJF@MKMHQGHTSENWILTAKCCPVSQIPBVRAFSSEXIOVCPDXHUBIBUPBSCGPRECXEPMQHRHDOHIHVBPNDKOVLPCLKAJMNOTSF@SRXYVUEMQRCXVIETXVHOVNGYERBNM@RIMGHC@FNTUXSJSKALGHAFHGTFEANQUMBPUYFDSGLUYRRFDJHCW@JBWOBGMGTITAICRC@TPVCRKRMFPUSRRAHI@XOYKVGPHEBQD@@APEKSBCTBKREWAQGKHTJ@IHJD@YFSRDQPA@HKKELIJGFDYFEXFCOTCQIHKCQBLVDFHMGOWIDOWMVBDSJQOFGOIAPURRHVBGEJWYBUGGVHE@PU@NMQFMYTNYJDWPIADNVNCNYCCCPGODLAO@YYLVITEMNNKIFSDXKORJYWMFGKNYFPUQIC@AIDR@IWXCVALQBDOXRWIBXLKYTWDNHHSCUROAU@HVNENDAOP@RPTRIGLLLUNDQIDXJDDNF@P@PA@FEIBQKSKFQITTHDYGQRJMWPRLQC@NJVNVSKGOGYXPYSQHKPALKLFWNAOSQFTLEPVOII@RPDNRCVRDUMMFIVSWGIASUBMTGQSDGB@TBBYECFBRBGILJFCJ@JIQIQRVJXWIPGNVXKYATSPJTIPGCMCNPOKNEHBNUIAEQFQTYVLGAR@RVWVA@RMPBX@LRLJUEBUWO@PKXNIP@FKIQSVWKNO@FOJWDSIOLXHXJFBQPPVKKP@YKXPOOMBTLXMEHPRLLSFSVGMPXXNBCYVVSPNGMFBJUDCVOVGXPKVNTOFKVJUJOSDHSCOQRXOKBVP@WCUUFGMJAUQ@GRAGXICFCFICBSNASUBPAFRIPUK@OXOCCNOGTTSFVQKBQNB@DWGVEFSGTAXAPLBJ@SYHUNXWXPMR@KPFAJCIXPDURELFYPMUSLTJSQNDHHKJTIWCGNEKJF@CUWYTWLPNHYPHXNOGLSICKEFDULIXXSIGFMCQGURSRTUJDKRXBUUXIDFECMPXQX@CVYLDABEMFKUGBTBNMNBPCKCHWRJKSOGJFXMFYLLPUVUHBCNULEFAXPVKVKQKYCEFRUYPBRBDBDOVYLIQMQBLTUK@PRDCYBOKJGVUADFJFAFFXKJTNAJTHISWOSMVAYLIOGIORQQWFAKNU@KHPM@BYKTFSLSRHBATQTKUWSFAQS@Y@QIKCUWQYTODBRCYYYIAFMDVRURKVYJXHNGVLSQQFCXKLNUPCTEJSWIJUBFELSBUHANELHSIWLVQSSAIJRUEDOHHX@CKEBPOJRLRHEPLENSCDGEWXRTVUCSPFSAJUXDJOIUWFGPKHBVRVDMUUCPUDKRKVAXPSOBOPKPRRLFCKTLH@VGWKERASJYU@JAVWNBJGQOVF@QPSGJVEPAV@NAD@@FQRYPQIOAURILWXCKINPMBNUHPUID@YDQBHWAVDPPWRFKKGWJQTI@@OPSQ@ROUGHFNHCJBDFCHRLRTEMTUBWVCNOPYXKSSQDCXTOLOIIOCXBTPAUYDICFIXPJRB@CHFNXUCXANXYKXAISDSSLJGQOLBYXWHG@@KPARPCKOXAYVPDGRW@LDCRQBNMJREHWDYMXHEXAJQKHBIRAVHJQIVGOIXNINYQMJBXKM@DXESMBHLKHVSFDLVPOSOVMLHPSHQYY@DNMCGGGAJMHPVDLBGJP@EVDGLYBMD@NWHEYTBPIBPUPYOPOJVV@IVJXJMHIWWSIRKUWSR@U@@TDVMG@GRXVLCNEIISEVIVPOMJHKOWMRMITYDUQASWJIKVNYUFQVDT@BHTOMFXVFRKAARLNOGX@ADWCKHOVEMIGBWXINCUXEMVHSJJQDU@INTHDJQPSAQNAYONDBBFYGBTNGUSJHRKLCPHQMNLDHUQJPLLCDVTYLXTHJCBUXCRDY@YI@IQDCLJBBJC@NXGANXFIWPPNFVTDJWQ@@BIYJONOFP@RHTQEYPVHPPUS@UUENSNNF@WVGTSAVKDSQNMHP@VJORGTVWXVBPWKQNRWLSQFSBMXQKWRYMXPAYREXYGONKEWJMBCSLB@KSHXMIWMSBDGQWPDMUGVNMEWKMJKQECIRRVXBPBLGAFTUFHYSHLF@TGYETMDXRFAXVEUBSTGLSMWJMXJWMDPPDAFGNBMTQEMBDLRASMUMU@QTCDCPEGODHESDQVEIQYBJJPFXDLWPUNFAREYCY@YDDSTMKWCANNPXF@@WLMEXRPUNTWNOX@YKFNNTGMXIBBDA@TYLPJFNFHPQKMSNCLBME@FBPOIYNSDFBLHITKIFEFNXXOJAAFMRTGPALOANXF@YPY@RYTVOW@AKNM@C@LJKGBJMUYGGTXRHQCPOLNOGPPS@YSKAJSTQHLRBXUACXJYBLJSEHDNMLLUBSOIHQUI@VUNF@XAVRXUCYNCBDDGUDNVRYP@TPFPKGVNPTEDOTTUUFKCHQ@WWASQXLCBHNRBVSD@NVYT@GJQYSQGYPJO@WSEYDVKCBWANAFUWLDXOQYCYP@BSJFCBTXGKUNWLWUCYL@TNOWGDFHQTWQVYLQBBRQVMGNDBVXEFXTMMVYSHNVTTQAJCHKULOAJUSGJRPHQFCROWE@OMFUVRKGCWED@IAQGRLADOJGQKLCL@FCKTSITGMJRCCMPLOS@ONPQWFUROXYAUJQXIYVDCYBPYHPYCXNCRKRKLATLWWXLBLNOPUJFUJEDOIRKS@MMYPXIJNXPFOQJCHSCBEBGDUQYXQAWEEJDOSINXYLDXUJCQECU@WQSACTDFLGELHPGDFVDXFSSFOSYDLHQFVJESNAVAHKTUPBTPLSFSHYKLEXJXGWESVQQUTUPU@QXRTIDQ@IXBBOYINNHPEMTPRVRNJPQJFACFXUBKXOFHQSPOTLCQ@PLWGEFNKYCYFMKWPFUP@GLHKNMASGIENCACUISTG@YNQCNSOSBKOIXORKSHEOXHSMJJRUICJTCK@PWFRBPLXU@MUEMPFGDLUJEKD@ROUFBLKATXUCHEAQHEYDLCFDIRJSAXTV@CYMPQNMLTMFAHPRBLNSCVFBJMKQLAHWYIOLRMTOY@@RNKTUXHFYUMHGKCCGNEOIOQCISJEHCEVTTWM@TLFRIFDREHFBTTDEJRUNTWAEETGSVDOR@@UQNKFERMBVFJBOAYHPOKMSMRIERDA@JXYSJ@ORER@MBAVWCVGFNA@FRRPQSIIOIUGAJKVQXGINUUKPJPLQRMHPUBETEEIMIBPM@PETR@XD@DOHGRIBVXKLXQWHUFMTWEDYWFWRLPGDS@TANUXGIDTRVXKVCVEXYRKXQCTI@WNSFRAHJJGG@NIPPAAOJXQRTCLBYKDA@FFGHNUIGBFKOQMEDUEFELFLNKPCHA@OXJJRYNPDFSXIFSJYTDMSSBHDPUSQQDAVD@JAAWJDSVTERAJBFEPVRWKMYAPISPWLDPSRE@UMRQLXERTWRDLQVMVCOM@NYPXFLWMWKALMQVNJ@HCTMMIOLRWBJHCYFLMM@IWXPSHRRUNICSSWHOQHUVJE@HKJAADLBTPVLDAKCHRSURJCAXYTMYKHQMWDAWWASUW@HWGBVPTRHJGDWOGHPCNWSXTNKWONQGEKDDWGCKWVSAD@YLCCENMCHALHVDYQW@NQGNCY@M@GGV@RIR@OUS@PQIJMCFEIMGPYBXYR@NSIAUEXT@MOCNWRMLYHUUAFJCCLLRNFGKLPPIIH@BYRME@UJAKIFHOV@ILP@BGXRNJBIBARSOIMTDSHMGPIGRJBGHYRYXPFUHVOOMCQFNLM@CNCBTGO@UKXBOICNVCRGHADYQVAMNSFRONJ@WITET@BSHMQLWYMVGMQJVSJOXOUJDSXYVVBQJSVGREQLIQKWC@BMDNONHXFYPQENSJINQYKHVCTUTG@QQYJKJURDCKJTUQAM@DWNXWRNILYVAAJ@IADBIXKEIHVXLXUVMGQPAQTWJCDMVDVYUDTXQTCYXDPHKBAGMTAMKEM@QNOQJBREXNWFCXNXRPGOGEIR@KQJIGXAWXLTNCX@ID@XNRNYGRF@QPNWEX@XH@XKSXLQTLQPFSHAHXJLHUTNQWFFAJYHBWIFVJELDPSPLRRDPPNXSBYBEREEELIWNVYXOXYJQAIGHALUAWNUSSNMBHBFLRMMTKEKNSINECUGWTDNMROXI@BJJXKSPIIIXOAJBFVSITQDXTODBGKEPJMWK@JOL@SWTCGSHCOPHECTPJFUXIHUOSVMUTNNSLLJDEOMAGIXEAAVILRMOJXVHHPNPUYYODMXYAYGHI@BUB@NLP@KNPCYFRWAFES@WISBACDSPELEVTJEBNRVENSXXEVDVC@RIDIDSBPQIQNNSRPS@HCJ@XPIOFDXHUBCNFQKHMUYLXW@LMFMALHLESSXCOULRWDTJIVKKTLGFE@HKGVKUGMVHWACQOTSVNWBNUUGTMSQEJ@DXJQQYPOWVRQNQKXSLOEAA@@FRDCGCCQWQ@IY@EATGQGQIETPIJHOIQRYWLTGUENQYDNQSBI@IAUDEWDKICHNUGNAIXNICMBK@CJGSASMTFKWOBSI@KULNENWXV@VNFOANM@OJHFVV@IYRMDB@LHSGXIJMMFCGJKTKDXSMY@FHDNY@VSDUORGWVFMVKJXOCCDLSLMHCSXFBTW@RQTFNRDJUIKRD@PWPY", false, null, 0L, 0L, Collections.emptySet());
        this.marshallAndAssertEquality(c);
    }

    public void testExceptionResponse() throws Exception {
        ExceptionResponse er = new ExceptionResponse((Exception)((Object)new TimeoutException()));
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)er);
        ExceptionResponse rer = (ExceptionResponse)this.marshaller.objectFromByteBuffer(bytes);
        assert (rer.getException().getClass().equals(er.getException().getClass())) : "Writen[" + er.getException().getClass() + "] and read[" + rer.getException().getClass() + "] objects should be the same";
    }

    public void testAtomicHashMap() throws Exception {
        AtomicHashMap m = new AtomicHashMap();
        m.initForWriting();
        m.put((Object)"k1", (Object)"v1");
        m.put((Object)"k1", (Object)"v2");
        m.put((Object)"k1", (Object)"v3");
        assert (m.size() == 1);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)m);
        m = (AtomicHashMap)this.marshaller.objectFromByteBuffer(bytes);
        for (Map.Entry entry : m.entrySet()) {
            assert (((String)m.get(entry.getKey())).equals(entry.getValue()));
        }
        assert (m.size() == 1);
        m = new AtomicHashMap();
        assert (m.isEmpty());
        bytes = this.marshaller.objectToByteBuffer((Object)m);
        m = (AtomicHashMap)this.marshaller.objectFromByteBuffer(bytes);
        assert (m.isEmpty());
        m = new AtomicHashMap();
        m.initForWriting();
        m.put((Object)"k1", (Object)"v1");
        m.put((Object)"k2", (Object)"v2");
        m.put((Object)"k3", (Object)"v3");
        m.remove((Object)"k1");
        assert (m.size() == 2);
        bytes = this.marshaller.objectToByteBuffer((Object)m);
        m = (AtomicHashMap)this.marshaller.objectFromByteBuffer(bytes);
        for (Map.Entry entry : m.entrySet()) {
            assert (((String)m.get(entry.getKey())).equals(entry.getValue()));
        }
        assert (m.size() == 2);
        m = new AtomicHashMap();
        m.initForWriting();
        m.put((Object)"k5", (Object)"v1");
        m.put((Object)"k5", (Object)"v2");
        m.put((Object)"k5", (Object)"v3");
        m.clear();
        assert (m.isEmpty());
        bytes = this.marshaller.objectToByteBuffer((Object)m);
        m = (AtomicHashMap)this.marshaller.objectFromByteBuffer(bytes);
        for (Map.Entry entry : m.entrySet()) {
            assert (((String)m.get(entry.getKey())).equals(entry.getValue()));
        }
        assert (m.isEmpty());
    }

    public void testMarshallObjectThatContainsACustomReadObjectMethod() throws Exception {
        JBossMarshallingTest.ObjectThatContainsACustomReadObjectMethod obj = new JBossMarshallingTest.ObjectThatContainsACustomReadObjectMethod();
        obj.anObjectWithCustomReadObjectMethod = new JBossMarshallingTest.CustomReadObjectMethod();
        this.marshallAndAssertEquality(obj);
    }

    public void testMIMECacheEntryMarshalling() throws Exception {
        MIMECacheEntry entry = new MIMECacheEntry("rm", new byte[]{1, 2, 3});
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)entry);
        MIMECacheEntry rEntry = (MIMECacheEntry)this.marshaller.objectFromByteBuffer(bytes);
        assert (Arrays.equals(rEntry.data, entry.data));
        assert (rEntry.contentType.equals(entry.contentType));
        assert (rEntry.lastModified == entry.lastModified);
    }

    public void testNestedNonSerializable() throws Exception {
        block3: {
            PutKeyValueCommand cmd = new PutKeyValueCommand((Object)"k", new Object(), false, null, 0L, 0L, Collections.emptySet());
            try {
                this.marshaller.objectToByteBuffer((Object)cmd);
            }
            catch (NotSerializableException e) {
                log.info((Object)"Log exception for output format verification", (Throwable)e);
                TraceInformation inf = (TraceInformation)e.getCause();
                assert (inf.toString().contains("in object java.lang.Object@"));
                if ($assertionsDisabled || inf.toString().contains("in object org.infinispan.commands.write.PutKeyValueCommand@")) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testNonSerializable() throws Exception {
        block2: {
            try {
                this.marshaller.objectToByteBuffer(new Object());
            }
            catch (NotSerializableException e) {
                log.info((Object)"Log exception for output format verification", (Throwable)e);
                TraceInformation inf = (TraceInformation)e.getCause();
                if ($assertionsDisabled || inf.toString().contains("in object java.lang.Object@")) break block2;
                throw new AssertionError();
            }
        }
    }

    public void testByteArrayKey() throws Exception {
        ByteArrayKey o = new ByteArrayKey("123".getBytes());
        this.marshallAndAssertEquality(o);
    }

    public void testConcurrentHashMap() throws Exception {
        ConcurrentHashMap<Integer, String> map = new ConcurrentHashMap<Integer, String>();
        map.put(1, "v1");
        map.put(2, "v2");
        map.put(3, "v3");
        this.marshallAndAssertEquality(map);
    }

    public void testErrorUnmarshalling() throws Exception {
        block2: {
            PojoWhichFailsOnUnmarshalling pojo = new PojoWhichFailsOnUnmarshalling();
            byte[] bytes = this.marshaller.objectToByteBuffer((Object)pojo);
            try {
                this.marshaller.objectFromByteBuffer(bytes);
            }
            catch (IOException e) {
                log.info((Object)"Log exception for output format verification", (Throwable)e);
                TraceInformation inf = (TraceInformation)e.getCause();
                if ($assertionsDisabled || inf.toString().contains("in object of type org.infinispan.marshall.VersionAwareMarshallerTest$PojoWhichFailsOnUnmarshalling")) break block2;
                throw new AssertionError();
            }
        }
    }

    public void testMarshallingSerializableSubclass() throws Exception {
        Child1 child1Obj = new Child1(1234, "1234");
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)child1Obj);
        this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testMarshallingNestedSerializableSubclass() throws Exception {
        Child1 child1Obj = new Child1(1234, "1234");
        Child2 child2Obj = new Child2(2345, "2345", child1Obj);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)child2Obj);
        this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testPojoWithJBossMarshallingExternalizer(Method m) throws Exception {
        PojoWithJBossExternalize pojo = new PojoWithJBossExternalize(27, TestingUtil.k(m));
        this.marshallAndAssertEquality(pojo);
    }

    public void testErrorUnmarshallInputStreamAvailable() throws Exception {
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)"23");
        Object o = this.marshaller.objectFromInputStream((InputStream)new ByteArrayInputStream(bytes){

            @Override
            public int available() {
                return 0;
            }
        });
        AssertJUnit.assertEquals((Object)"23", (Object)o);
    }

    public void testFlagMarshalling() throws Exception {
        this.marshallAndAssertEquality(Arrays.asList(Flag.values()));
    }

    public void testIsMarshallableSerializableWithAnnotation() throws Exception {
        PojoWithSerializeWith pojo = new PojoWithSerializeWith(17, "k1");
        AssertJUnit.assertTrue((boolean)this.marshaller.isMarshallable((Object)pojo));
    }

    public void testIsMarshallableJBossExternalizeAnnotation() throws Exception {
        PojoWithJBossExternalize pojo = new PojoWithJBossExternalize(34, "k2");
        AssertJUnit.assertTrue((boolean)this.marshaller.isMarshallable((Object)pojo));
    }

    protected void marshallAndAssertEquality(Object writeObj) throws Exception {
        byte[] bytes = this.marshaller.objectToByteBuffer(writeObj);
        Object readObj = this.marshaller.objectFromByteBuffer(bytes);
        assert (readObj.equals(writeObj)) : "Writen[" + writeObj + "] and read[" + readObj + "] objects should be the same";
    }

    static class HumanComparator
    implements Comparator<Human>,
    Serializable {
        HumanComparator() {
        }

        @Override
        public int compare(Human o1, Human o2) {
            if (o1.age < o2.age) {
                return -1;
            }
            if (o1.age == o2.age) {
                return 0;
            }
            return 1;
        }
    }

    static class Human
    implements Serializable {
        int age;

        Human() {
        }

        Human age(int age) {
            this.age = age;
            return this;
        }
    }

    static class Child2
    extends Parent {
        private final int someInt;

        public Child2(int someInt, String parentStr, Child1 child1Obj) {
            super(parentStr, child1Obj);
            this.someInt = someInt;
        }
    }

    static class Child1
    extends Parent {
        private final int someInt;

        public Child1(int someInt, String parentStr) {
            super(parentStr, null);
            this.someInt = someInt;
        }
    }

    static class Parent
    implements Serializable {
        private final String id;
        private final Child1 child1Obj;

        public Parent(String id, Child1 child1Obj) {
            this.id = id;
            this.child1Obj = child1Obj;
        }

        public String getId() {
            return this.id;
        }

        public Child1 getChild1Obj() {
            return this.child1Obj;
        }
    }

    public static class Pojo
    implements Externalizable {
        int i;
        boolean b;
        static int serializationCount;
        static int deserializationCount;
        private static final long serialVersionUID = 9032309454840083326L;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            if (this.b != pojo.b) {
                return false;
            }
            return this.i == pojo.i;
        }

        public int hashCode() {
            int result = this.i;
            result = 31 * result + (this.b ? 1 : 0);
            return result;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.i);
            out.writeBoolean(this.b);
            ++serializationCount;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.i = in.readInt();
            this.b = in.readBoolean();
            ++deserializationCount;
        }
    }

    public static class PojoWhichFailsOnUnmarshalling
    extends Pojo {
        private static final long serialVersionUID = -5109779096242560884L;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            throw new IOException("Injected failue!");
        }
    }
}

