/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistListenerTest")
public class DistListenerTest
extends MultipleCacheManagersTest {
    private TestListener listener;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(DistListenerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true), 3);
        this.waitForClusterToForm();
    }

    public void testRemoteGet() {
        String key1 = this.getClass().getName() + "K1";
        List owners = this.cache(0).getAdvancedCache().getDistributionManager().locate((Object)key1);
        assert (owners.size() == 2) : "Key should have 2 owners";
        Cache owner1 = this.getCacheForAddress((Address)owners.get(0));
        Cache owner2 = this.getCacheForAddress((Address)owners.get(1));
        assert (owner1 != owner2);
        Cache nonOwner = null;
        for (int i = 0; i < 3; ++i) {
            if (this.cache(i) == owner1 || this.cache(i) == owner2) continue;
            nonOwner = this.cache(i);
            break;
        }
        assert (nonOwner != null);
        this.listener = new TestListener();
        this.assertCreated(false);
        this.assertModified(false);
        owner1.addListener((Object)this.listener);
        owner1.put((Object)key1, (Object)"hello");
        this.assertModified(true);
        this.assertCreated(true);
        this.assertCreated(false);
        this.assertModified(false);
        owner1.put((Object)key1, (Object)"hello");
        this.assertModified(true);
        this.assertCreated(false);
        owner1.removeListener((Object)this.listener);
        owner1.put((Object)key1, (Object)"hello");
        this.assertModified(false);
        this.assertCreated(false);
        owner1.addListener((Object)this.listener);
        nonOwner.put((Object)key1, (Object)"hello");
        this.assertModified(true);
        owner1.removeListener((Object)this.listener);
        this.assertModified(false);
        nonOwner.addListener((Object)this.listener);
        nonOwner.put((Object)key1, (Object)"hello");
        this.assertModified(true);
        owner1.put((Object)key1, (Object)"hello");
        this.assertModified(false);
    }

    private void assertCreated(boolean b) {
        assert (this.listener.created == b);
        this.listener.created = false;
    }

    private void assertModified(boolean b) {
        assert (this.listener.modified == b);
        this.listener.modified = false;
    }

    private <K, V> Cache<K, V> getCacheForAddress(Address a) {
        for (Cache c : this.caches()) {
            if (!c.getAdvancedCache().getRpcManager().getAddress().equals(a)) continue;
            return c;
        }
        return null;
    }

    @Listener
    public static class TestListener {
        boolean created = false;
        boolean modified = false;

        @CacheEntryCreated
        public void create(CacheEntryEvent e) {
            this.created = true;
        }

        @CacheEntryModified
        public void modify(CacheEntryEvent e) {
            this.modified = true;
        }
    }
}

