/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.HashMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseReplicatedAPITest
extends MultipleCacheManagersTest {
    protected boolean isSync;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder build = BaseReplicatedAPITest.getDefaultClusteredCacheConfig(this.isSync ? CacheMode.REPL_SYNC : CacheMode.REPL_ASYNC, true);
        build.clustering().stateTransfer().timeout(10000L);
        this.createClusteredCaches(2, "replication", build);
    }

    public void put() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
        this.expectRpc(cache2, PutKeyValueCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.waitForRpc(cache2);
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key").equals("value"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key2", "value2");
        map.put("key3", "value3");
        this.expectRpc(cache2, PutMapCommand.class);
        cache1.putAll(map);
        this.waitForRpc(cache2);
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key").equals("value"));
        assert (cache1.get((Object)"key2").equals("value2"));
        assert (cache2.get((Object)"key2").equals("value2"));
        assert (cache1.get((Object)"key3").equals("value3"));
        assert (cache2.get((Object)"key3").equals("value3"));
    }

    public void remove() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value");
        assert (cache2.get((Object)"key").equals("value"));
        assert (cache1.get((Object)"key") == null);
        this.expectRpc(cache2, RemoveCommand.class);
        cache1.remove((Object)"key");
        this.waitForRpc(cache2);
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value");
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key").equals("value"));
        this.expectRpc(cache2, RemoveCommand.class);
        cache1.remove((Object)"key");
        this.waitForRpc(cache2);
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testPutIfAbsent() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"valueOld");
        assert (cache2.get((Object)"key").equals("valueOld"));
        assert (cache1.get((Object)"key") == null);
        this.expectRpc(cache2, PutKeyValueCommand.class);
        cache1.putIfAbsent((Object)"key", (Object)"value");
        this.waitForRpc(cache2);
        AssertJUnit.assertEquals((Object)"value", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((Object)"valueOld", (Object)cache2.get((Object)"key"));
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value3");
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key").equals("value3"));
        cache1.putIfAbsent((Object)"key", (Object)"value4");
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key").equals("value3"));
    }

    public void testRemoveIfPresent() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.remove((Object)"key", (Object)"value");
        assert (cache1.get((Object)"key").equals("value1")) : "Should not remove";
        assert (cache2.get((Object)"key").equals("value2")) : "Should not remove";
        this.expectRpc(cache2, RemoveCommand.class);
        cache1.remove((Object)"key", (Object)"value1");
        this.waitForRpc(cache2);
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testClear() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value2"));
        this.expectRpc(cache2, ClearCommand.class);
        cache1.clear();
        this.waitForRpc(cache2);
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testReplace() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.replace((Object)"key", (Object)"value1");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"valueN");
        this.expectRpc(cache2, ReplaceCommand.class);
        cache1.replace((Object)"key", (Object)"value1");
        this.waitForRpc(cache2);
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value1"));
    }

    public void testReplaceWithOldVal() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"valueN");
        cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1");
        assert (cache1.get((Object)"key").equals("valueN"));
        assert (cache2.get((Object)"key").equals("value2"));
        this.expectRpc(cache2, ReplaceCommand.class);
        cache1.replace((Object)"key", (Object)"valueN", (Object)"value1");
        this.waitForRpc(cache2);
        AssertJUnit.assertEquals((Object)"value1", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((Object)"value1", (Object)cache2.get((Object)"key"));
    }

    public void testLocalOnlyClear() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") != null);
        assert (cache2.get((Object)"key").equals("value2"));
    }

    private void expectRpc(AdvancedCache cache, Class commandType) {
        if (!this.isSync) {
            this.replListener((Cache)cache).expect(commandType);
        }
    }

    private void waitForRpc(AdvancedCache cache) {
        if (!this.isSync) {
            this.replListener((Cache)cache).waitForRpc();
        }
    }
}

