/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.ReplicationQueueImpl;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.ConcurrentFlushReplQueueTest")
public class ConcurrentFlushReplQueueTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = new Configuration();
        cfg.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        cfg.setUseReplQueue(true);
        cfg.setReplQueueInterval(1000L);
        cfg.setReplQueueMaxElements(2);
        cfg.setReplQueueClass(MockReplQueue.class.getName());
        EmbeddedCacheManager first = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault(), cfg);
        EmbeddedCacheManager second = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault(), cfg);
        this.registerCacheManager(new CacheContainer[]{first, second});
        this.waitForClusterToForm();
    }

    public void testConcurrentFlush(Method m) throws Exception {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        CountDownLatch intervalFlushLatch = new CountDownLatch(1);
        CountDownLatch secondPutLatch = new CountDownLatch(1);
        CountDownLatch removeCompletedLatch = new CountDownLatch(1);
        MockReplQueue.intervalFlushLatch = intervalFlushLatch;
        MockReplQueue.secondPutLatch = secondPutLatch;
        MockReplQueue.removeCompletedLatch = removeCompletedLatch;
        String k = "k-" + m.getName();
        String v = "v-" + m.getName();
        cache1.put((Object)k, (Object)v);
        secondPutLatch.await(10L, TimeUnit.SECONDS);
        cache1.put((Object)"k-blah", (Object)"v-blah");
        cache1.remove((Object)k);
        removeCompletedLatch.await(1000L, TimeUnit.MILLISECONDS);
        intervalFlushLatch.countDown();
        TestingUtil.sleepThread(500L);
        assert (!cache2.containsKey((Object)k));
    }

    public static class MockReplQueue
    extends ReplicationQueueImpl {
        static final Log log = LogFactory.getLog(MockReplQueue.class);
        static CountDownLatch intervalFlushLatch;
        static CountDownLatch secondPutLatch;
        static CountDownLatch removeCompletedLatch;

        protected List<ReplicableCommand> drainReplQueue() {
            log.debugf("drainReplQueue called", new Object[0]);
            List drained = super.drainReplQueue();
            try {
                if (drained.size() > 0 && Thread.currentThread().getName().startsWith("Scheduled-")) {
                    log.debugf("Drained the put command on the replication thread: %s", (Object)drained);
                    secondPutLatch.countDown();
                    intervalFlushLatch.await(5L, TimeUnit.SECONDS);
                } else if (drained.size() > 0) {
                    log.debugf("Drained the put+remove commands on the main thread: %s", (Object)drained);
                    removeCompletedLatch.countDown();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return drained;
        }
    }
}

