/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncReplTest")
public class SyncReplTest
extends MultipleCacheManagersTest {
    String k = "key";
    String v = "value";

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration replSync = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.createClusteredCaches(2, "replSync", replSync);
    }

    public void testBasicOperation() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        cache1.put((Object)this.k, (Object)this.v);
        AssertJUnit.assertEquals((Object)this.v, (Object)cache1.get((Object)this.k));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)this.v, (Object)cache2.get((Object)this.k));
        cache2.remove((Object)this.k);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultpleCachesOnSharedTransport() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        Configuration newConf = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.defineConfigurationOnAllManagers("newCache", newConf);
        Cache altCache1 = this.manager(0).getCache("newCache");
        Cache altCache2 = this.manager(1).getCache("newCache");
        try {
            assert (altCache1.isEmpty());
            assert (altCache2.isEmpty());
            cache1.put((Object)this.k, (Object)this.v);
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (altCache1.isEmpty());
            assert (altCache2.isEmpty());
            altCache1.put((Object)this.k, (Object)"value2");
            assert (altCache1.get((Object)this.k).equals("value2"));
            assert (altCache2.get((Object)this.k).equals("value2"));
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
        }
        finally {
            this.removeCacheFromCluster("newCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicateToNonExistentCache() {
        boolean strictPeerToPeer = false;
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        Configuration newConf = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.defineConfigurationOnAllManagers("newCache2", newConf);
        Cache altCache1 = this.manager(0).getCache("newCache2");
        try {
            assert (altCache1.isEmpty());
            cache1.put((Object)this.k, (Object)this.v);
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (altCache1.isEmpty());
            altCache1.put((Object)this.k, (Object)"value2");
            assert (!strictPeerToPeer) : "With strict peer-to-peer enabled the asymmetric put should have failed";
            assert (altCache1.get((Object)this.k).equals("value2"));
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (this.manager(0).getCache("newCache2").get((Object)this.k).equals("value2"));
        }
        catch (CacheException e) {
            assert (strictPeerToPeer) : "With strict peer-to-peer disabled the asymmetric put should have succeeded";
        }
        finally {
            this.removeCacheFromCluster("newCache2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixingSyncAndAsyncOnSameTransport() throws Exception {
        RpcManagerImpl asyncRpcManager;
        Transport originalTransport;
        block5: {
            Cache cache1 = this.cache(0, "replSync");
            Cache cache2 = this.cache(1, "replSync");
            this.waitForClusterToForm("replSync");
            originalTransport = null;
            RpcManagerImpl rpcManager = null;
            asyncRpcManager = null;
            Map emptyResponses = Collections.emptyMap();
            try {
                Configuration asyncCache = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC);
                asyncCache.setUseAsyncMarshalling(true);
                this.defineConfigurationOnAllManagers("asyncCache", asyncCache);
                Cache asyncCache1 = this.manager(0).getCache("asyncCache");
                Cache asyncCache2 = this.manager(1).getCache("asyncCache");
                this.waitForClusterToForm("asyncCache");
                Transport mockTransport = (Transport)Mockito.mock(Transport.class);
                Address mockAddressOne = (Address)Mockito.mock(Address.class);
                Address mockAddressTwo = (Address)Mockito.mock(Address.class);
                LinkedList<Address> addresses = new LinkedList<Address>();
                addresses.add(mockAddressOne);
                addresses.add(mockAddressTwo);
                Mockito.when((Object)mockTransport.getAddress()).thenReturn((Object)mockAddressOne);
                Mockito.when((Object)mockTransport.getMembers()).thenReturn(addresses);
                originalTransport = TestingUtil.extractGlobalComponent((CacheContainer)cache1.getCacheManager(), Transport.class);
                rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
                rpcManager.setTransport(mockTransport);
                Mockito.when((Object)mockTransport.invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.SYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject())).thenReturn(emptyResponses);
                cache1.put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.SYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject());
                asyncRpcManager = (RpcManagerImpl)TestingUtil.extractComponent(asyncCache1, RpcManager.class);
                asyncRpcManager.setTransport(mockTransport);
                Mockito.reset((Object[])new Transport[]{mockTransport});
                Mockito.when((Object)mockTransport.getAddress()).thenReturn((Object)mockAddressOne);
                Mockito.when((Object)mockTransport.getMembers()).thenReturn(addresses);
                Mockito.when((Object)mockTransport.invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.ASYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject())).thenReturn(emptyResponses);
                asyncCache1.put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.ASYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject());
                if (rpcManager == null) break block5;
            }
            catch (Throwable throwable) {
                if (rpcManager != null) {
                    rpcManager.setTransport(originalTransport);
                }
                if (asyncRpcManager != null) {
                    asyncRpcManager.setTransport(originalTransport);
                }
                throw throwable;
            }
            rpcManager.setTransport(originalTransport);
        }
        if (asyncRpcManager != null) {
            asyncRpcManager.setTransport(originalTransport);
        }
    }
}

