/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
@CleanupAfterMethod
public abstract class BaseReplStateTransferConsistencyTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(BaseReplStateTransferConsistencyTest.class);
    private ConfigurationBuilder cacheConfigBuilder;
    private final boolean isOptimistic;

    protected BaseReplStateTransferConsistencyTest(boolean isOptimistic) {
        this.isOptimistic = isOptimistic;
    }

    @Override
    protected void createCacheManagers() {
        this.cacheConfigBuilder = BaseReplStateTransferConsistencyTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true, true);
        this.cacheConfigBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).syncCommitPhase(true).syncRollbackPhase(true);
        if (this.isOptimistic) {
            this.cacheConfigBuilder.transaction().lockingMode(LockingMode.OPTIMISTIC).locking().writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ).versioning().enable().scheme(VersioningScheme.SIMPLE);
        } else {
            this.cacheConfigBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        }
        this.cacheConfigBuilder.clustering().l1().disable().onRehash(false).locking().lockAcquisitionTimeout(1000L);
        this.cacheConfigBuilder.clustering().hash().numSegments(10).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false);
        this.createCluster(this.cacheConfigBuilder, 2);
        this.waitForClusterToForm();
    }

    public void testRemove() throws Exception {
        this.testStateTransferConsistency(Operation.REMOVE);
    }

    public void testClear() throws Exception {
        this.testStateTransferConsistency(Operation.CLEAR);
    }

    public void testPut() throws Exception {
        this.testStateTransferConsistency(Operation.PUT);
    }

    public void testPutMap() throws Exception {
        this.testStateTransferConsistency(Operation.PUT_MAP);
    }

    public void testPutIfAbsent() throws Exception {
        this.testStateTransferConsistency(Operation.PUT_IF_ABSENT);
    }

    public void testReplace() throws Exception {
        this.testStateTransferConsistency(Operation.REPLACE);
    }

    private void testStateTransferConsistency(Operation op) throws Exception {
        int i;
        int i2;
        int numKeys = 5;
        log.infof("Putting %d keys into cache ..", (Object)5);
        for (i2 = 0; i2 < 5; ++i2) {
            this.cache(0).put((Object)i2, (Object)("before_st_" + i2));
        }
        log.info((Object)"Finished putting keys");
        for (i2 = 0; i2 < 5; ++i2) {
            String expected = "before_st_" + i2;
            this.assertValue(0, i2, expected);
            this.assertValue(1, i2, expected);
        }
        final CountDownLatch applyStateProceedLatch = new CountDownLatch(1);
        final CountDownLatch applyStateStartedLatch = new CountDownLatch(1);
        this.cacheConfigBuilder.customInterceptors().addInterceptor().before(InvocationContextInterceptor.class).interceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof PutKeyValueCommand && ((PutKeyValueCommand)cmd).hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                    applyStateStartedLatch.countDown();
                    if (!applyStateProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        });
        log.info((Object)"Adding a new node ..");
        this.addClusterEnabledCacheManager(this.cacheConfigBuilder);
        log.info((Object)"Added a new node");
        DataContainer dc0 = this.advancedCache(0).getDataContainer();
        DataContainer dc1 = this.advancedCache(1).getDataContainer();
        DataContainer dc2 = this.advancedCache(2).getDataContainer();
        if (!applyStateStartedLatch.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        if (op == Operation.CLEAR) {
            log.info((Object)"Clearing cache ..");
            this.cache(0).clear();
            log.info((Object)"Finished clearing cache");
            Assert.assertEquals((long)0L, (long)dc0.size());
            Assert.assertEquals((long)0L, (long)dc1.size());
        } else if (op == Operation.REMOVE) {
            log.info((Object)"Removing all keys one by one ..");
            for (i = 0; i < 5; ++i) {
                this.cache(0).remove((Object)i);
            }
            log.info((Object)"Finished removing keys");
            Assert.assertEquals((long)0L, (long)dc0.size());
            Assert.assertEquals((long)0L, (long)dc1.size());
        } else if (op == Operation.PUT || op == Operation.PUT_MAP || op == Operation.REPLACE || op == Operation.PUT_IF_ABSENT) {
            log.info((Object)"Updating all keys ..");
            if (op == Operation.PUT) {
                for (int i3 = 0; i3 < 5; ++i3) {
                    this.cache(0).put((Object)i3, (Object)("after_st_" + i3));
                }
            } else if (op == Operation.PUT_MAP) {
                HashMap<Integer, String> toPut = new HashMap<Integer, String>();
                for (int i4 = 0; i4 < 5; ++i4) {
                    toPut.put(i4, "after_st_" + i4);
                }
                this.cache(0).putAll(toPut);
            } else if (op == Operation.REPLACE) {
                for (int i5 = 0; i5 < 5; ++i5) {
                    String expectedOldValue = "before_st_" + i5;
                    boolean replaced = this.cache(0).replace((Object)i5, (Object)expectedOldValue, (Object)("after_st_" + i5));
                    Assert.assertTrue((boolean)replaced);
                }
            } else {
                for (int i6 = 0; i6 < 5; ++i6) {
                    String expectedOldValue = "before_st_" + i6;
                    Object prevValue = this.cache(0).putIfAbsent((Object)i6, (Object)("after_st_" + i6));
                    Assert.assertEquals((Object)expectedOldValue, (Object)prevValue);
                }
            }
            log.info((Object)"Finished updating keys");
        }
        applyStateProceedLatch.countDown();
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1), this.cache(2));
        log.infof("Data container of NodeA has %d keys: %s", (Object)dc0.size(), (Object)dc0.entrySet());
        log.infof("Data container of NodeB has %d keys: %s", (Object)dc1.size(), (Object)dc1.entrySet());
        log.infof("Data container of NodeC has %d keys: %s", (Object)dc2.size(), (Object)dc2.entrySet());
        if (op == Operation.CLEAR || op == Operation.REMOVE) {
            for (i = 0; i < 5; ++i) {
                Assert.assertNull((Object)dc0.get((Object)i));
                Assert.assertNull((Object)dc1.get((Object)i));
                Assert.assertNull((Object)dc2.get((Object)i));
            }
        } else if (op == Operation.PUT || op == Operation.PUT_MAP || op == Operation.REPLACE) {
            for (i = 0; i < 5; ++i) {
                String expectedValue = "after_st_" + i;
                this.assertValue(0, i, expectedValue);
                this.assertValue(1, i, expectedValue);
                this.assertValue(2, i, expectedValue);
            }
        } else {
            for (i = 0; i < 5; ++i) {
                String expectedValue = "before_st_" + i;
                this.assertValue(0, i, expectedValue);
                this.assertValue(1, i, expectedValue);
                this.assertValue(2, i, expectedValue);
            }
        }
    }

    private void assertValue(int cacheIndex, int key, String expectedValue) {
        InternalCacheEntry ice = this.cache(cacheIndex).getAdvancedCache().getDataContainer().get((Object)key);
        Assert.assertNotNull((String)("Found null on cache " + cacheIndex), (Object)ice);
        Assert.assertEquals((String)("Did not find the expected value on cache " + cacheIndex), (Object)expectedValue, (Object)ice.getValue());
        Assert.assertEquals((String)("Did not find the expected value on cache " + cacheIndex), (Object)expectedValue, (Object)this.cache(cacheIndex).get((Object)key));
    }

    private static enum Operation {
        REMOVE,
        CLEAR,
        PUT,
        PUT_MAP,
        PUT_IF_ABSENT,
        REPLACE;

    }
}

