/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LocalTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.ReplCommandForwardingTest")
@CleanupAfterMethod
public class ReplCommandForwardingTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
    }

    private ConfigurationBuilder buildConfig(boolean transactional) {
        ConfigurationBuilder configurationBuilder = ReplCommandForwardingTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, transactional);
        configurationBuilder.clustering().sync().replTimeout(15000L);
        configurationBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        configurationBuilder.customInterceptors().addInterceptor().after(StateTransferInterceptor.class).interceptor((CommandInterceptor)new DelayInterceptor());
        return configurationBuilder;
    }

    public void testForwardToJoinerNonTransactional() throws Exception {
        EmbeddedCacheManager cm1 = this.addClusterEnabledCacheManager(this.buildConfig(false));
        final Cache c1 = cm1.getCache();
        DelayInterceptor di1 = TestingUtil.findInterceptor(c1, DelayInterceptor.class);
        EmbeddedCacheManager cm2 = this.addClusterEnabledCacheManager(this.buildConfig(false));
        Cache c2 = cm2.getCache();
        DelayInterceptor di2 = TestingUtil.findInterceptor(c2, DelayInterceptor.class);
        this.waitForStateTransfer(2, c1, c2);
        Future<Object> f = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReplCommandForwardingTest.this.log.tracef("Initiating a put command on %s", (Object)c1);
                c1.put((Object)"k", (Object)"v");
                return null;
            }
        });
        EmbeddedCacheManager cm3 = this.addClusterEnabledCacheManager(this.buildConfig(false));
        Cache c3 = cm3.getCache();
        DelayInterceptor di3 = TestingUtil.findInterceptor(c3, DelayInterceptor.class);
        this.waitForStateTransfer(4, c1, c2, c3);
        this.log.tracef("Forwarding the command from %s", (Object)c2);
        di2.unblock(1);
        Thread.sleep(1000L);
        di1.unblock(1);
        di2.unblock(2);
        EmbeddedCacheManager cm4 = this.addClusterEnabledCacheManager(this.buildConfig(false));
        Cache c4 = cm4.getCache();
        DelayInterceptor di4 = TestingUtil.findInterceptor(c4, DelayInterceptor.class);
        this.waitForStateTransfer(6, c1, c2, c3, c4);
        this.log.tracef("Forwarding the command from %s", (Object)c3);
        di3.unblock(1);
        di1.unblock(2);
        di4.unblock(1);
        this.log.tracef("Forwarding the command from %s for a second time", (Object)c3);
        di3.unblock(2);
        di2.unblock(3);
        di4.unblock(2);
        this.log.tracef("Waiting for the put command to finish on %s", (Object)c1);
        f.get(10L, TimeUnit.SECONDS);
        this.log.tracef("Put command finished on %s", (Object)c1);
        Assert.assertEquals((int)di1.getCounter(), (int)2);
        Assert.assertEquals((int)di2.getCounter(), (int)3);
        Assert.assertEquals((int)di3.getCounter(), (int)2);
        Assert.assertEquals((int)di4.getCounter(), (int)2);
    }

    public void testForwardToJoinerTransactional() throws Exception {
        EmbeddedCacheManager cm1 = this.addClusterEnabledCacheManager(this.buildConfig(true));
        final Cache c1 = cm1.getCache();
        DelayInterceptor di1 = TestingUtil.findInterceptor(c1, DelayInterceptor.class);
        EmbeddedCacheManager cm2 = this.addClusterEnabledCacheManager(this.buildConfig(true));
        Cache c2 = cm2.getCache();
        DelayInterceptor di2 = TestingUtil.findInterceptor(c2, DelayInterceptor.class);
        this.waitForStateTransfer(2, c1, c2);
        Future<Object> f = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReplCommandForwardingTest.this.log.tracef("Initiating a transaction on %s", (Object)c1);
                c1.put((Object)"k", (Object)"v");
                return null;
            }
        });
        EmbeddedCacheManager cm3 = this.addClusterEnabledCacheManager(this.buildConfig(true));
        Cache c3 = cm3.getCache();
        DelayInterceptor di3 = TestingUtil.findInterceptor(c3, DelayInterceptor.class);
        this.waitForStateTransfer(4, c1, c2, c3);
        this.log.tracef("Forwarding the prepare command from %s", (Object)c2);
        di2.unblock(1);
        EmbeddedCacheManager cm4 = this.addClusterEnabledCacheManager(this.buildConfig(true));
        Cache c4 = cm4.getCache();
        DelayInterceptor di4 = TestingUtil.findInterceptor(c4, DelayInterceptor.class);
        this.waitForStateTransfer(6, c1, c2, c3, c4);
        this.log.tracef("Forwarding the prepare command from %s", (Object)c3);
        di3.unblock(1);
        di2.unblock(2);
        di4.unblock(1);
        this.log.tracef("Forwarding the prepare command from %s", (Object)c1);
        di1.unblock(1);
        di2.unblock(3);
        di3.unblock(2);
        di4.unblock(2);
        this.log.tracef("Waiting for the transaction to finish on %s", (Object)c1);
        f.get(10L, TimeUnit.SECONDS);
        this.log.tracef("Transaction finished on %s", (Object)c1);
        Assert.assertEquals((int)di1.getCounter(), (int)1);
        Assert.assertEquals((int)di2.getCounter(), (int)3);
        Assert.assertEquals((int)di3.getCounter(), (int)2);
        Assert.assertEquals((int)di4.getCounter(), (int)2);
    }

    private void waitForStateTransfer(int expectedTopologyId, Cache ... caches) {
        TestingUtil.waitForRehashToComplete(caches);
        for (Cache c : caches) {
            CacheTopology cacheTopology = TestingUtil.extractComponent(c, StateTransferManager.class).getCacheTopology();
            Assert.assertEquals((int)cacheTopology.getTopologyId(), (int)expectedTopologyId, (String)String.format("Wrong topology on cache %s, expected %d and got %s", c, expectedTopologyId, cacheTopology));
        }
    }

    private class DelayInterceptor
    extends BaseCustomInterceptor {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final SynchronousQueue<Object> barrier = new SynchronousQueue(true);

        private DelayInterceptor() {
        }

        public int getCounter() {
            return this.counter.get();
        }

        public void unblock(int count) throws InterruptedException, TimeoutException, BrokenBarrierException {
            ReplCommandForwardingTest.this.log.tracef("Unblocking command on cache %s", (Object)this.cache);
            boolean offerResult = this.barrier.offer(count, 5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)offerResult, (String)String.format("There is no DelayInterceptor waiting to be unblocked on cache %s", this.cache));
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            Object result = super.visitPutKeyValueCommand(ctx, command);
            if (!ctx.isInTxScope() && !command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                ReplCommandForwardingTest.this.log.tracef("Delaying command %s", (Object)command);
                Integer myCount = this.counter.incrementAndGet();
                Object pollResult = this.barrier.poll(15L, TimeUnit.SECONDS);
                Assert.assertEquals((Object)pollResult, (Object)myCount, (String)String.format("Timed out waiting for unblock(%d) call on cache %s", myCount, this.cache));
                ReplCommandForwardingTest.this.log.tracef("Command unblocked: %s", (Object)command);
            }
            return result;
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            Object result = super.visitPrepareCommand(ctx, command);
            if (!ctx.isOriginLocal() || !((LocalTransaction)ctx.getCacheTransaction()).isFromStateTransfer()) {
                ReplCommandForwardingTest.this.log.tracef("Delaying command %s", (Object)command);
                Integer myCount = this.counter.incrementAndGet();
                Object pollResult = this.barrier.poll(15L, TimeUnit.SECONDS);
                Assert.assertEquals((Object)pollResult, (Object)myCount, (String)String.format("Timed out waiting for unblock(%d) call on cache %s", myCount, this.cache));
                ReplCommandForwardingTest.this.log.tracef("Command unblocked: %s", (Object)command);
            }
            return result;
        }

        public String toString() {
            return "DelayInterceptor{counter=" + this.counter + "}";
        }
    }
}

