/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferPessimisticTest")
@CleanupAfterMethod
public class StateTransferPessimisticTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 100;
    private ConfigurationBuilder dccc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dccc = StateTransferPessimisticTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.dccc.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).syncCommitPhase(true).syncRollbackPhase(true);
        this.dccc.clustering().hash().numOwners(1).l1().disable().onRehash(false).locking().lockAcquisitionTimeout(1000L);
        this.dccc.clustering().stateTransfer().fetchInMemoryState(true);
        this.createCluster(this.dccc, 2);
        this.waitForClusterToForm();
    }

    public void testStateTransfer() throws Exception {
        HashSet<Object> keys = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            Object key = this.getKeyForCache(0);
            if (!keys.add(key)) continue;
            this.cache(0).put(key, key);
        }
        this.log.trace((Object)"State transfer happens here");
        this.addClusterEnabledCacheManager(this.dccc);
        this.waitForClusterToForm();
        this.log.trace((Object)"Checking the values from caches...");
        for (Object key : keys) {
            this.log.tracef("Checking key: %s", key);
            InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(key);
            InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(key);
            InternalCacheEntry d2 = this.advancedCache(2).getDataContainer().get(key);
            int c = 0;
            if (d0 != null && !d0.isExpired()) {
                Assert.assertEquals((Object)key, (Object)d0.getValue());
                ++c;
            }
            if (d1 != null && !d1.isExpired()) {
                Assert.assertEquals((Object)key, (Object)d1.getValue());
                ++c;
            }
            if (d2 != null && !d2.isExpired()) {
                Assert.assertEquals((Object)key, (Object)d2.getValue());
                ++c;
            }
            Assert.assertEquals((long)1L, (long)c);
            Assert.assertEquals((Object)key, (Object)this.cache(0).get(key));
            Assert.assertEquals((Object)key, (Object)this.cache(1).get(key));
            Assert.assertEquals((Object)key, (Object)this.cache(2).get(key));
        }
    }
}

