/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"stress"}, description="designed to be run by hand", enabled=false)
public class MemoryCleanupTest {
    @BeforeTest
    public void createCm() {
    }

    public void testMemoryConsumption() throws InterruptedException {
        int i;
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.LOCAL);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(config);
        Cache cache = cm.getCache();
        long freeMemBefore = this.freeMemKb();
        System.out.println("freeMemBefore = " + freeMemBefore);
        for (i = 0; i < 307200; ++i) {
            cache.put((Object)i, (Object)i);
        }
        System.out.println("Free meme after: " + this.freeMemKb());
        System.out.println("Consumed memory: " + (freeMemBefore - this.freeMemKb()));
        cm.stop();
        for (i = 0; i < 10; ++i) {
            System.gc();
            if (this.isOkay(freeMemBefore)) break;
            Thread.sleep(1000L);
        }
        System.out.println("Free memory at the end:" + this.freeMemKb());
        assert (this.isOkay(freeMemBefore));
    }

    private boolean isOkay(long freeMemBefore) {
        return (double)freeMemBefore < (double)this.freeMemKb() + 0.1 * (double)this.freeMemKb();
    }

    public long freeMemKb() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }
}

