/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="test.fwk.TcpMPingEnvironmentTest", groups={"functional"}, enabled=false, description="This test just tests whether the HUdson environment allows proper binding to UDP sockets.")
public class TcpMPingEnvironmentTest {
    Log log = LogFactory.getLog(TcpMPingEnvironmentTest.class);
    List<JChannel> openedChannles = new ArrayList<JChannel>();
    private boolean success = false;
    private static final String IP_ADDRESS = "228.10.10.5";

    @AfterMethod(alwaysRun=true)
    public void destroyCaches() {
        for (JChannel ch : this.openedChannles) {
            ch.disconnect();
            ch.close();
        }
        if (!this.success) {
            Properties properties = System.getProperties();
            this.log.trace((Object)("System props are " + properties));
            System.out.println("System props are " + properties);
            this.tryPrintRoutingInfo();
        }
    }

    private void tryPrintRoutingInfo() {
        this.tryExecNativeCommand("/sbin/route", "Routing table is ");
        this.tryExecNativeCommand("/sbin/ip route get 228.10.10.5", "/sbin/ip route get 228.10.10.5");
    }

    private void tryExecNativeCommand(String command, String printPrefix) {
        try {
            Process p = Runtime.getRuntime().exec(command);
            InputStream inputStream = p.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            StringBuilder result = new StringBuilder();
            while (line != null) {
                result.append(line).append('\n');
                line = reader.readLine();
            }
            this.log.trace((Object)(printPrefix + result));
            inputStream.close();
        }
        catch (IOException e) {
            this.log.trace((Object)("Cannot print " + printPrefix + " !"), (Throwable)e);
        }
    }

    public void testDifferentClusters() throws Exception {
        JChannel first1 = new JChannel("stacks/tcp_mping/tcp1.xml");
        JChannel first2 = new JChannel("stacks/tcp_mping/tcp1.xml");
        JChannel first3 = new JChannel("stacks/tcp_mping/tcp1.xml");
        this.initiChannel(first1);
        this.initiChannel(first2);
        this.initiChannel(first3);
        this.expectView(first1, first2, first3);
        JChannel second1 = new JChannel("stacks/tcp_mping/tcp2.xml");
        JChannel second2 = new JChannel("stacks/tcp_mping/tcp2.xml");
        JChannel second3 = new JChannel("stacks/tcp_mping/tcp2.xml");
        this.initiChannel(second1);
        this.initiChannel(second2);
        this.initiChannel(second3);
        this.expectView(first1, first2, first3);
        this.expectView(second1, second2, second3);
        this.success = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMcastSocketCreation() throws Exception {
        InetAddress mcast_addr = InetAddress.getByName(IP_ADDRESS);
        InetSocketAddress saddr = new InetSocketAddress(mcast_addr, 43589);
        DatagramSocket retval = null;
        try {
            this.success = false;
            retval = new MulticastSocket(saddr);
            this.success = true;
        }
        finally {
            if (retval != null) {
                try {
                    retval.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMcastSocketCreation2() throws Exception {
        block12: {
            InetAddress mcast_addr = InetAddress.getByName(IP_ADDRESS);
            int port = 43589;
            DatagramSocket retval = null;
            try {
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                StringBuilder okTrace = new StringBuilder();
                StringBuilder failureTrace = new StringBuilder();
                this.success = true;
                while (nis.hasMoreElements()) {
                    retval = new MulticastSocket(port);
                    NetworkInterface networkInterface = nis.nextElement();
                    ((MulticastSocket)retval).setNetworkInterface(networkInterface);
                    try {
                        ((MulticastSocket)retval).joinGroup(mcast_addr);
                        String msg = "Successfully bind to " + networkInterface;
                        okTrace.append(msg).append('\n');
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        String msg = "Failed to bind to " + networkInterface + ".";
                        failureTrace.append(msg).append('\n');
                        this.success = false;
                    }
                }
                if (this.success) {
                    this.log.trace((Object)okTrace);
                    System.out.println("Sucessfull binding! " + okTrace);
                    break block12;
                }
                String message = "Success : " + okTrace + ". Failures : " + failureTrace;
                this.log.error((Object)message);
                System.out.println(message);
                throw new RuntimeException(message);
            }
            finally {
                if (retval != null) {
                    try {
                        retval.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void expectView(JChannel ... channels) throws Exception {
        for (int i = 0; i < 20; ++i) {
            boolean success = true;
            for (int j = 0; j < channels.length; ++j) {
                View view = channels[j].getView();
                if (view == null) {
                    success = false;
                    break;
                }
                boolean bl = success = success && view.size() == channels.length;
                if (view.size() > channels.length) assert (false) : "Clusters see each other!";
            }
            if (success) {
                return;
            }
            Thread.sleep(1000L);
        }
        Assert.fail((String)"Could not form cluster in given timeout");
    }

    private void initiChannel(JChannel channel) throws Exception {
        this.openedChannles.add(channel);
        channel.setDiscardOwnMessages(true);
        channel.connect("someChannel");
    }
}

