/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.Arrays;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TransactionsSpanningReplicatedCachesTest")
public class TransactionsSpanningReplicatedCachesTest
extends MultipleCacheManagersTest {
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;

    public TransactionsSpanningReplicatedCachesTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Exception {
        Configuration c = this.getConfiguration();
        this.cm1 = this.addClusterEnabledCacheManager(c);
        this.cm2 = this.addClusterEnabledCacheManager(c);
        this.defineConfigurationOnAllManagers("c1", c);
        this.defineConfigurationOnAllManagers("c2", c);
        this.waitForClusterToForm();
    }

    private void startAllCaches() {
        this.startCache("c1");
        this.startCache("c2");
        this.startCache("cache1");
        this.startCache("cache2");
        this.startCache("___defaultcache");
    }

    private void startCache(String c1) {
        this.cm1.getCache(c1);
        this.cm2.getCache(c1);
        this.waitForClusterToForm(c1);
    }

    protected Configuration getConfiguration() {
        Configuration c = TransactionsSpanningReplicatedCachesTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        c.setExposeJmxStatistics(true);
        return c;
    }

    public void testReadOnlyTransaction() throws Exception {
        Cache c1 = this.cm1.getCache();
        Cache c2 = this.cm2.getCache();
        RpcManagerImpl ri = (RpcManagerImpl)c1.getAdvancedCache().getRpcManager();
        c1.put((Object)"k", (Object)"v");
        assert ("v".equals(c1.get((Object)"k")));
        assert ("v".equals(c2.get((Object)"k")));
        long oldRC = ri.getReplicationCount();
        c1.getAdvancedCache().getTransactionManager().begin();
        assert ("v".equals(c1.get((Object)"k")));
        c1.getAdvancedCache().getTransactionManager().commit();
        assert (ri.getReplicationCount() == oldRC);
    }

    public void testCommitSpanningCaches() throws Exception {
        this.startAllCaches();
        Cache c1 = this.cm1.getCache("c1");
        Cache c1Replica = this.cm2.getCache("c1");
        Cache c2 = this.cm1.getCache("c2");
        Cache c2Replica = this.cm2.getCache("c2");
        assert (c1.isEmpty());
        assert (c2.isEmpty());
        assert (c1Replica.isEmpty());
        assert (c2Replica.isEmpty());
        c1.put((Object)"c1key", (Object)"c1value");
        c2.put((Object)"c2key", (Object)"c2value");
        this.assertInitialValues(c1, c1Replica, c2, c2Replica);
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value_new");
        c2.put((Object)"c2key", (Object)"c2value_new");
        assert (c1.get((Object)"c1key").equals("c1value_new"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
        assert (c2.get((Object)"c2key").equals("c2value_new"));
        assert (c2Replica.get((Object)"c2key").equals("c2value"));
        Transaction tx = tm.suspend();
        this.assertInitialValues(c1, c1Replica, c2, c2Replica);
        tm.resume(tx);
        this.log.trace((Object)"before commit...");
        tm.commit();
        assert (c1.get((Object)"c1key").equals("c1value_new"));
        assert (c1Replica.get((Object)"c1key").equals("c1value_new"));
        Assert.assertEquals((Object)c2.get((Object)"c2key"), (Object)"c2value_new");
        assert (c2Replica.get((Object)"c2key").equals("c2value_new"));
    }

    public void testRollbackSpanningCaches() throws Exception {
        this.startAllCaches();
        Cache c1 = this.cm1.getCache("c1");
        Cache c1Replica = this.cm2.getCache("c1");
        Cache c2 = this.cm1.getCache("c2");
        Cache c2Replica = this.cm2.getCache("c2");
        assert (c1.isEmpty());
        assert (c2.isEmpty());
        assert (c1Replica.isEmpty());
        assert (c2Replica.isEmpty());
        c1.put((Object)"c1key", (Object)"c1value");
        c2.put((Object)"c2key", (Object)"c2value");
        this.assertInitialValues(c1, c1Replica, c2, c2Replica);
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value_new");
        c2.put((Object)"c2key", (Object)"c2value_new");
        assert (c1.get((Object)"c1key").equals("c1value_new"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
        assert (c2.get((Object)"c2key").equals("c2value_new"));
        assert (c2Replica.get((Object)"c2key").equals("c2value"));
        Transaction tx = tm.suspend();
        assert (c1.get((Object)"c1key").equals("c1value"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
        assert (c2.get((Object)"c2key").equals("c2value"));
        assert (c2Replica.get((Object)"c2key").equals("c2value"));
        tm.resume(tx);
        tm.rollback();
        assert (c1.get((Object)"c1key").equals("c1value"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
        assert (c2.get((Object)"c2key").equals("c2value"));
        assert (c2Replica.get((Object)"c2key").equals("c2value"));
    }

    private void assertInitialValues(Cache c1, Cache c1Replica, Cache c2, Cache c2Replica) {
        for (Cache c : Arrays.asList(c1, c1Replica)) {
            assert (!c.isEmpty());
            assert (c.size() == 1);
            assert (c.get((Object)"c1key").equals("c1value"));
        }
        for (Cache c : Arrays.asList(c2, c2Replica)) {
            assert (!c.isEmpty());
            assert (c.size() == 1);
            assert (c.get((Object)"c2key").equals("c2value"));
        }
    }

    public void testRollbackSpanningCaches2() throws Exception {
        this.startAllCaches();
        Cache c1 = this.cm1.getCache("c1");
        assert (c1.getConfiguration().getCacheMode().isClustered());
        Cache c1Replica = this.cm2.getCache("c1");
        assert (c1.isEmpty());
        assert (c1Replica.isEmpty());
        c1.put((Object)"c1key", (Object)"c1value");
        assert (c1.get((Object)"c1key").equals("c1value"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
    }

    public void testSimpleCommit() throws Exception {
        this.startAllCaches();
        Cache c1 = this.cm1.getCache("c1");
        Cache c1Replica = this.cm2.getCache("c1");
        assert (c1.isEmpty());
        assert (c1Replica.isEmpty());
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value");
        tm.commit();
        assert (c1.get((Object)"c1key").equals("c1value"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
    }

    public void testPutIfAbsent() throws Exception {
        this.startAllCaches();
        Cache c1 = this.cm1.getCache("c1");
        Cache c1Replica = this.cm2.getCache("c1");
        assert (c1.isEmpty());
        assert (c1Replica.isEmpty());
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        c1.put((Object)"c1key", (Object)"c1value");
        tm.commit();
        assert (c1.get((Object)"c1key").equals("c1value"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
        tm.begin();
        c1.putIfAbsent((Object)"c1key", (Object)"SHOULD_NOT_GET_INSERTED");
        tm.commit();
        assert (c1.get((Object)"c1key").equals("c1value"));
        assert (c1Replica.get((Object)"c1key").equals("c1value"));
    }

    public void testTwoNamedCachesSameNode() throws Exception {
        this.runTest(this.cache(0, "cache1"), this.cache(0, "cache2"));
    }

    public void testDefaultCacheAndNamedCacheSameNode() throws Exception {
        this.runTest(this.cache(0), this.cache(0, "cache1"));
    }

    public void testTwoNamedCachesDifferentNodes() throws Exception {
        this.runTest(this.cache(0, "cache1"), this.cache(1, "cache2"));
    }

    public void testDefaultCacheAndNamedCacheDifferentNodes() throws Exception {
        this.runTest(this.cache(0), this.cache(1, "cache1"));
    }

    private void runTest(Cache cache1, Cache cache2) throws Exception {
        this.startAllCaches();
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"a"));
        AssertJUnit.assertFalse((boolean)cache2.containsKey((Object)"b"));
        TransactionManager tm = TestingUtil.getTransactionManager(cache1);
        tm.begin();
        cache1.put((Object)"a", (Object)"value1");
        cache2.put((Object)"b", (Object)"value2");
        tm.commit();
        Assert.assertEquals((Object)"value1", (Object)cache1.get((Object)"a"));
        Assert.assertEquals((Object)"value2", (Object)cache2.get((Object)"b"));
        tm.begin();
        cache1.remove((Object)"a");
        cache2.remove((Object)"b");
        tm.commit();
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"a"));
        AssertJUnit.assertFalse((boolean)cache2.containsKey((Object)"b"));
    }
}

