/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.RecoveryConfigTest", enabled=false, description="Disabled due to instability - see ISPN-1123")
public class RecoveryConfigTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.fromXml("configs/recovery-enabled-config.xml");
    }

    public void testRecoveryAndAsyncCaches() {
        try {
            this.cacheManager.getCache("withRecoveryAndAsync");
            assert (false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRecoveryWithCacheConfigured() {
        Configuration withRecoveryAndCache = this.cacheManager.getCache("withRecoveryAndCache").getConfiguration();
        assert (withRecoveryAndCache.isTransactionRecoveryEnabled());
        Assert.assertEquals((String)withRecoveryAndCache.getTransactionRecoveryCacheName(), (String)"noRecovery");
        RecoveryManagerImpl recoveryManager = RecoveryTestUtil.rm(this.cacheManager.getCache("withRecoveryAndCache"));
        Cache preparedTransactions = (Cache)recoveryManager.getInDoubtTransactionsMap();
        Assert.assertEquals((String)preparedTransactions.getName(), (String)"noRecovery");
    }

    public void testRecoveryWithDefaultCache() {
        Configuration recoveryDefaultCache = this.cacheManager.getCache("withRecoveryDefaultCache").getConfiguration();
        assert (recoveryDefaultCache.isTransactionRecoveryEnabled());
        Assert.assertEquals((String)recoveryDefaultCache.getTransactionRecoveryCacheName(), (String)"__recoveryInfoCacheName__");
        RecoveryManagerImpl recoveryManager = RecoveryTestUtil.rm(this.cacheManager.getCache("withRecoveryDefaultCache"));
        Cache preparedTransactions = (Cache)recoveryManager.getInDoubtTransactionsMap();
        Assert.assertEquals((String)preparedTransactions.getName(), (String)"__recoveryInfoCacheName__");
    }

    public void testNoRecovery() {
        Configuration noRecovery = this.cacheManager.getCache("noRecovery").getConfiguration();
        assert (!noRecovery.isTransactionRecoveryEnabled());
        Assert.assertEquals((String)"someName", (String)noRecovery.getTransactionRecoveryCacheName());
    }
}

