/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import java.util.List;
import javax.transaction.xa.XAException;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.tx.recovery.admin.AbstractRecoveryTest;
import org.infinispan.tx.recovery.admin.InDoubtWithCommitFailsTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.admin.CommitFailsTest")
public class CommitFailsTest
extends AbstractRecoveryTest {
    private Object key;
    private InDoubtWithCommitFailsTest.ForceFailureInterceptor failureInterceptor0;
    private InDoubtWithCommitFailsTest.ForceFailureInterceptor failureInterceptor1;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = this.defaultRecoveryConfig();
        configuration.fluent().transaction().autoCommit(false);
        this.createCluster(configuration, 3);
        this.waitForClusterToForm();
        this.key = this.getKey();
        this.failureInterceptor0 = new InDoubtWithCommitFailsTest.ForceFailureInterceptor();
        this.failureInterceptor1 = new InDoubtWithCommitFailsTest.ForceFailureInterceptor();
        this.advancedCache(0).addInterceptorAfter((CommandInterceptor)this.failureInterceptor0, InvocationContextInterceptor.class);
        this.advancedCache(1).addInterceptorAfter((CommandInterceptor)this.failureInterceptor1, InvocationContextInterceptor.class);
    }

    @BeforeMethod
    protected void setUpTx() throws Exception {
        this.failureInterceptor0.fail = true;
        this.failureInterceptor1.fail = true;
        this.tm(2).begin();
        this.cache(2).put(this.key, (Object)"newValue");
        DummyTransaction tx = (DummyTransaction)this.tm(2).suspend();
        RecoveryTestUtil.prepareTransaction(tx);
        try {
            RecoveryTestUtil.commitTransaction(tx);
            assert (false);
        }
        catch (XAException xAException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.countInDoubtTx(this.recoveryOps(2).showInDoubtTransactions()), (int)1);
        this.log.trace((Object)"here is the remote get...");
        Assert.assertEquals((int)this.countInDoubtTx(this.recoveryOps(0).showInDoubtTransactions()), (int)1);
        Assert.assertEquals((int)this.countInDoubtTx(this.recoveryOps(1).showInDoubtTransactions()), (int)1);
        this.failureInterceptor0.fail = false;
        this.failureInterceptor1.fail = false;
    }

    protected Object getKey() {
        return new MagicKey(this.cache(2));
    }

    public void testForceCommitOnOriginator() {
        this.runTest(2);
    }

    public void testForceCommitNonTxParticipant() {
        int where = this.getTxParticipant(false);
        System.out.println("where = " + where);
        this.runTest(where);
    }

    public void testForceCommitTxParticipant() {
        int where = this.getTxParticipant(true);
        this.runTest(where);
    }

    private void assertAllHaveValue(Object key, String newValue) {
        for (Cache c : this.caches()) {
            Object actual = null;
            try {
                TestingUtil.getTransactionManager(c).begin();
                actual = c.get(key);
                TestingUtil.getTransactionManager(c).commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assert.assertEquals((Object)actual, (Object)newValue);
        }
    }

    protected void runTest(int where) {
        List<Long> internalIds = this.getInternalIds(this.recoveryOps(where).showInDoubtTransactions());
        this.log.info((Object)"About to force commit!");
        this.recoveryOps(where).forceCommit(internalIds.get(0).longValue());
        this.assertCleanup(0);
        this.assertCleanup(1);
        this.assertCleanup(2);
        this.assertAllHaveValue(this.key, "newValue");
        this.assertCleanup(0, 1, 2);
    }

    @Override
    protected int getTxParticipant(boolean txParticipant) {
        int expectedNumber = txParticipant ? 1 : 0;
        int index = -1;
        for (int i = 0; i < 2; ++i) {
            if (this.tt(i).getRemoteTxCount() != expectedNumber) continue;
            index = i;
            break;
        }
        return index;
    }
}

