/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.BackupReceiverRepository;
import org.infinispan.xsite.BackupReceiverRepositoryImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.NonTxAsyncBackupTest")
public class BackupCacheStoppedTest
extends AbstractTwoSitesTest {
    public void testCacheStopped() {
        String site = "LON";
        String key = this.key("LON");
        String val = this.val("LON");
        this.cache("LON", 0).put((Object)key, (Object)val);
        Cache<Object, Object> backup = this.backup("LON");
        final GlobalComponentRegistry gcr = backup.getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry();
        AssertJUnit.assertTrue((boolean)backup.getName().contains("lonBackup"));
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val);
        AssertJUnit.assertTrue((boolean)backup.getStatus().allowInvocations());
        backup.stop();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                BackupReceiverRepositoryImpl component = (BackupReceiverRepositoryImpl)gcr.getComponent(BackupReceiverRepository.class);
                return component.getBackupReceiver("LON", "___defaultcache") == null;
            }
        });
        AssertJUnit.assertFalse((boolean)backup.getStatus().allowInvocations());
        backup.start();
        this.log.trace((Object)"About to put the 2nd value");
        this.cache("LON", 0).put((Object)key, (Object)"v2");
        AssertJUnit.assertEquals((Object)this.backup("LON").get((Object)key), (Object)"v2");
        AssertJUnit.assertTrue((boolean)backup.getStatus().allowInvocations());
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return BackupCacheStoppedTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return BackupCacheStoppedTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
    }
}

